/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class LoadRequirementsFromTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest          request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        AssessmentCriteriaTemplate  template    =   job.getAssessmentTemplate();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside LoadRequirementsFromTemplateFP for ", job, " load from template:", template);
        
        for(AssessmentCriteria criteria : template.getAssessmentCriteriasSet())
        {
            AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(objTran);
            
            criteriaCopy.setName(criteria.getName());
            criteriaCopy.setImportance(criteria.getImportance());
            criteriaCopy.setCriteriaType(criteria.getCriteriaType());
            criteriaCopy.setJob(job);
        }
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "LoadRequirementsFromTemplateFP completed for ", job);
        
        return RedisplayResult.getInstance();
    }
}

