import { Component, OnInit } from '@angular/core';
import { PersonalDetailsService } from '../../../services/personal-details.service';
import { CareerProfileModel } from '../../../models/career-profile.model';
import { UtilsService } from '../../../../oneit/services/utils.service';
import { BaseComponent } from '../../../base/base.component';
import { takeUntil } from 'rxjs/operators';

@Component({
  selector: 'app-publish',
  templateUrl: './publish.component.html',
  styleUrls: ['./publish.component.scss']
})
export class PublishComponent extends BaseComponent implements OnInit {

    assocs = [];
    careerProfile = new CareerProfileModel();

    constructor(
        private personalDetailsService: PersonalDetailsService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.personalDetailsService.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
                console.log(this.careerProfile);
                this.updatedObjs[this.careerProfile.ObjectID] = this.careerProfile;
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

    saveProfile(): void {
        this.isSaving = true;
        this.personalDetailsService.saveProfile(this.createdObjs, this.updatedObjs, this.deletedObjs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(res => {
                this.isSaving = false;
                this.getCareerProfile();
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

}
