package performa.orm;

import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.filter.Filter;
import oneit.utils.math.Statistics;


public class TestAnalysis extends BaseTestAnalysis
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public TestAnalysis ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    @Override
    public String getObjectIDSpace()
    {
        return "TestAnalysis";
    }
    
    //Related to CANDIDATE_LEVEL_SCORE - LEVEL_SCORE
    public double getLevelScore()
    {
        return Statistics.sum(pipelineTestAnalysis().toCandidateClassScores().toClassScore().vals());
    }
    
    //Related to CANDIDATE_LEVEL_SCORE - WEIGHTED_LEVEL_SCORE
    public double getWghtdLevelScore()
    {
        return Statistics.sum(pipelineTestAnalysis().toCandidateClassScores().toWghtdClassScore().vals());
    }
    
    //Related to CANDIDATE_LEVEL_SCORE - MAX_WGHT_LEVEL_SCORE
    public double getMaxWghtdLevelScore()
    {
        return Statistics.sum(pipelineTestAnalysis().toCandidateClassScores().toMaxWghtdClassScore().vals());
    }
    
    public FactorScore getFactorScoreFor(Factor factor)
    {
        Filter<FactorScore> factorScoreFilter   =   FactorScore.SearchByAll().andFactor(new EqualsFilter(factor));
                    
        return pipelineTestAnalysis().toFactorScores(factorScoreFilter).val();
    }

}