<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*, oneit.utils.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState         process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran         =   process.getTransaction();
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "Applications");
    WorkFlow                workFlow        =   (WorkFlow) getData(request, "WorkFlow");
%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" /> 
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                &nbsp;<span class="ref-no">(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)</span>
                <%
                    }
                %>
            </div>

            <div class="by-name">
                <div class="header-right-status">
                    <span class="light-calendar">
                        <%
                            if(job.getJobStatus() == JobStatus.OPEN)
                            {
                                int daysToClose =   job.getNoOfDaystoClosed();
                        %>
                                <span class="number">
                                    <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                                </span>
                                <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                        <%
                            }
                            else
                            {
                        %>
                                <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                                <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                        <%
                            }
                        %>
                    </span>
                    <span class="job-status-appli">
                        <span class="<%= job.getJobStatus().getName().toLowerCase() + " status-icon" %>"></span>
                        <oneit:toString  value="<%= job.getJobStatusText() %>"    mode="EscapeHTML"/>
                    </span>
                </div>
                    <div>
                <span class="austr-post">
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                &nbsp;&nbsp;.&nbsp;&nbsp;
                <oneit:toString value="<%= job.getOccupation() %>"   mode="EscapeHTML" />
                    </div>
            </div>


        </div>
        <div class="white-header">          
            <div class="main-appli-name">
                <div class="appli-name"><%= workFlow == null || workFlow.getApplicationStatus() == ApplicationStatus.SUBMITTED ? "All" : workFlow.getName() %> Applicants </div>
            </div>
            <div class="appli-count">
                <%= applications.size() %> Applicants
            </div>
       </div>
    
    <div class="view-appli-list">
    <%
        for (JobApplication jobApplication : applications)
        {
            String  roleFit     =   FormatUtils.stringify(jobApplication.getRoleFitPercentage(), "PercentageWholeNumber", "0");
            String  culture     =   FormatUtils.stringify(jobApplication.getCultureFitScore(), "PercentageWholeNumber", "0");
    %>
        <div class="appli-row">        
            <div class="appli-list-name appli-l"> 
                <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                <div class="appli-status">
                    <oneit:toString value="<%= jobApplication.getApplicantStatusStr() %>"   mode="EscapeHTML" />
                </div>
            </div>
            <div class="appli-overall appli-l">
                Overall rank
                <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
            </div>
            
            <div class="appli-jcs appli-l eq-second-height">
                <span class="appli-view-bar">
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= roleFit %>" aria-valuemin="0" aria-valuemax="100" 
                                style="<%= "width: " + roleFit %>">
                            <span class="show-precentage"><%= roleFit %></span>
                        </div>
                    </div>
                </span>
                role fit
            </div>
            <%
                if(job.showCultureCriteriaSection())
                {
            %>            
                    <div class="appli-jcs appli-l eq-second-height">
                        <span class="appli-view-bar">
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                        style="<%= "width: " + culture %>">
                                    <span class="show-precentage"><%= culture %></span>
                                </div>                                
                            </div>
                        </span>
                        culture fit
                    </div>
            <%
                }

                if(job.showAssessmentCriteriaSection())
                {
                    long    criteriaVal =   jobApplication.getRequirementFitScore();
                    String  criteria    =   FormatUtils.stringify(criteriaVal, "PercentageWholeNumber", "0");
                    boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
                    String  iconBg      =   "background-image : url('file://" + PDFUtils.FILE_BASE_PATH + "/images/has_req.png'); ";
                    if (missingReq)     iconBg      =   "background-image : url('file://" + PDFUtils.FILE_BASE_PATH + "/images/no_req.png');" ;
                %>
                    <div class="appli-jcs appli-l eq-second-height">
                        <span class="appli-view-bar">
                            <div class="progress">
                                <div class="progress-bar <%= (criteriaVal == 100 && !missingReq ? " green" : "")%>" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                        style="<%= "width: " + criteria %>">
                                    <span class="show-precentage"><%= criteria %></span>
                                </div>
                            </div>
                              
                                <span class="<%= missingReq ? "red" : "green" %> requirements-icon" ></span>
                        </span>
                        <span class="<%= missingReq ? "red-requirements" : "" %>">
                            requirements
                           
                        </span>
                    </div>
                             
            <%
                }
            %>           
             <div style="clear:both"></div>            
        </div>
    <%
        }
    %>
    </div>
    </div>
</oneit:dynIncluded>