import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { environment } from '../../../../environments/environment';
import { ApiService } from '../../../oneit/services/api.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class ApplicantPortalLayoutService {

    userDataUpdated = new Subject<any>();
    userData: any;
    jobId: string;

    constructor(
        private apiService: ApiService,
        private utilsService: UtilsService
    ) {

    }

    reloadApplicantUserDetails(job, key): void {
        if (job && key) {
            const params = {
                environment: environment.envName,
                Job: job,
                Key: key
            };

            this.apiService.post('svc/ApplicantUserDetails', params)
                .subscribe(
                    data => {
                        if (this.utilsService.isSuccessfulResponse(data)) {
                            this.jobId = job;
                            this.userData = data;
                            this.userDataUpdated.next(data);
                        }
                    });
        }
    }
}
