import { ChangeDetectorRef, Component, Input, OnInit } from '@angular/core';

import { MenuItem } from 'primeng/primeng';

import { Subscription } from 'rxjs/Subscription';

import { MenuService } from './../../services/menu.service';
import { UtilsService } from './../../services/utils.service';

import { FullLayoutComponent } from './../full-layout/full-layout.component';


@Component({
    selector: 'app-header',
    templateUrl: './header.component.html',
    styleUrls: ['./header.component.scss']
})
export class HeaderComponent implements OnInit {

    @Input() showMenu: boolean = true;
    mainMenuItems: MenuItem[] = [];
    topMenuItems: MenuItem[] = [];
    subscriptions: Array<Subscription> = [];

    constructor(
        private changeDetector: ChangeDetectorRef,
        public app: FullLayoutComponent,
        private menuService: MenuService,
        private utilsService: UtilsService
    ) {

    }

    ngOnInit() {
        this.subscriptions.push(this.menuService.menuUpdated.subscribe(
            data => {
                this.mainMenuItems = data.mainMenu.reverse();
                this.topMenuItems = data.topMenu;

                if (this.app.isMobile() && data.mainMenu && data.mainMenu.length > 0) {
                    this.mainMenuItems.push(this.mainMenuItems.shift());
                    this.mainMenuItems = this.mainMenuItems.reverse();  //So that user menu will be at the top for Mobile, and rest menu items preserve order
                }
                //Commented as this stops whole system when called from iframe component! Assume User will have minor performance issue because of this
                //this.changeDetector.detectChanges();
            }
        ));
    }

    ngOnDestroy() {
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}