package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.MultiException;
import oneit.utils.StringUtils;
import performa.orm.CompanyUser;


public class SaveUserDetailsFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        SecUser             secUser     =   companyUser.getUser();     
        
        LogMgr.log(CompanyUser.LOG, LogLevel.PROCESSING1,"In SaveUserDetailsFP saving CompanyUser : ", companyUser );
         
        if(companyUser.getConfirmPassword() != null)
        {
            secUser.setAttribute("md5:" + SecUser.FIELD_Password, companyUser.getConfirmPassword());
        }
        
        return super.processForm(process, submission, params);
    }
    
        
    @Override
    protected Map validate(SubmissionDetails submission, MultiException exceptions) 
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        SecUser             secUser     =   companyUser.getUser();
        
        BusinessObjectParser.assertFieldCondition(StringUtils.isEmailAddress(secUser.getUserName()), secUser, SecUser.FIELD_Email, "invalid", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(secUser.getFirstName()!= null, secUser, SecUser.FIELD_FirstName, "mandatory", exceptions, true, request);
        BusinessObjectParser.assertFieldCondition(secUser.getLastName()!= null, secUser, SecUser.FIELD_LastName, "mandatory", exceptions, true, request);
//        BusinessObjectParser.assertFieldCondition(CollectionUtils.equals(companyUser.getPassword(), companyUser.getConfirmPassword()), companyUser, Job.FIELD_ConfirmPassword, "passwordNotMatch", exceptions, true, request);
        
        return super.validate(submission, exceptions);
    }
}