
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import performa.orm.types.TimeZone;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CompanyPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea CompanyPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Company");

    // Private attributes corresponding to business object data
    private String dummyCompanyName;
    private BinaryContent dummyCompanyLogo;
    private HiringTeamType dummyHiringTeamType;
    private Industry dummyIndustry;
    private TimeZone dummyTimeZone;
    private Boolean dummyIsVerified;
    private State dummyState;
    private Countries dummyCountry;
    private String dummyPostCode;
    private String dummyCity;
    private Boolean dummyHasClientSupport;
    private String dummyStripeReference;
    private String dummyStripeSubscription;
    private String dummyNameOnCard;
    private String dummyCardPostCode;
    private String dummyCardID;
    private Date dummyPlanRenewedOn;
    private Integer dummyUsedCredits;
    private CompanyStatus dummyCompanyStatus;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_CompanyName = DefaultAttributeHelper.INSTANCE;
    private static final BLOBAttributeHelper HELPER_CompanyLogo = BLOBAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_HiringTeamType = new EnumeratedAttributeHelper (HiringTeamType.FACTORY_HiringTeamType);
    private static final EnumeratedAttributeHelper HELPER_Industry = new EnumeratedAttributeHelper (Industry.FACTORY_Industry);
    private static final EnumeratedAttributeHelper HELPER_TimeZone = new EnumeratedAttributeHelper (TimeZone.FACTORY_TimeZone);
    private static final DefaultAttributeHelper HELPER_IsVerified = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_State = new EnumeratedAttributeHelper (State.FACTORY_State);
    private static final EnumeratedAttributeHelper HELPER_Country = new EnumeratedAttributeHelper (Countries.FACTORY_Countries);
    private static final DefaultAttributeHelper HELPER_PostCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_City = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_HasClientSupport = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeReference = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeSubscription = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_NameOnCard = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CardPostCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CardID = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PlanRenewedOn = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_UsedCredits = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_CompanyStatus = new EnumeratedAttributeHelper (CompanyStatus.FACTORY_CompanyStatus);
    



    public CompanyPersistenceMgr ()
    {
        dummyCompanyName = (String)(HELPER_CompanyName.initialise (dummyCompanyName));
        dummyCompanyLogo = (BinaryContent)(HELPER_CompanyLogo.initialise (dummyCompanyLogo));
        dummyHiringTeamType = (HiringTeamType)(HELPER_HiringTeamType.initialise (dummyHiringTeamType));
        dummyIndustry = (Industry)(HELPER_Industry.initialise (dummyIndustry));
        dummyTimeZone = (TimeZone)(HELPER_TimeZone.initialise (dummyTimeZone));
        dummyIsVerified = (Boolean)(HELPER_IsVerified.initialise (dummyIsVerified));
        dummyState = (State)(HELPER_State.initialise (dummyState));
        dummyCountry = (Countries)(HELPER_Country.initialise (dummyCountry));
        dummyPostCode = (String)(HELPER_PostCode.initialise (dummyPostCode));
        dummyCity = (String)(HELPER_City.initialise (dummyCity));
        dummyHasClientSupport = (Boolean)(HELPER_HasClientSupport.initialise (dummyHasClientSupport));
        dummyStripeReference = (String)(HELPER_StripeReference.initialise (dummyStripeReference));
        dummyStripeSubscription = (String)(HELPER_StripeSubscription.initialise (dummyStripeSubscription));
        dummyNameOnCard = (String)(HELPER_NameOnCard.initialise (dummyNameOnCard));
        dummyCardPostCode = (String)(HELPER_CardPostCode.initialise (dummyCardPostCode));
        dummyCardID = (String)(HELPER_CardID.initialise (dummyCardID));
        dummyPlanRenewedOn = (Date)(HELPER_PlanRenewedOn.initialise (dummyPlanRenewedOn));
        dummyUsedCredits = (Integer)(HELPER_UsedCredits.initialise (dummyUsedCredits));
        dummyCompanyStatus = (CompanyStatus)(HELPER_CompanyStatus.initialise (dummyCompanyStatus));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_company.object_id as id, {PREFIX}tl_company.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_company.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_company.company_name, {PREFIX}tl_company.company_logo, {PREFIX}tl_company.hiring_team_type, {PREFIX}tl_company.industry, {PREFIX}tl_company.time_zone, {PREFIX}tl_company.is_verified, {PREFIX}tl_company.state, {PREFIX}tl_company.country, {PREFIX}tl_company.post_code, {PREFIX}tl_company.city, {PREFIX}tl_company.has_client_support, {PREFIX}tl_company.stripe_reference, {PREFIX}tl_company.stripe_subscription, {PREFIX}tl_company.name_on_card, {PREFIX}tl_company.card_post_code, {PREFIX}tl_company.card_id, {PREFIX}tl_company.plan_renewed_on, {PREFIX}tl_company.used_credits, {PREFIX}tl_company.company_status, {PREFIX}tl_company.added_by_user_id, {PREFIX}tl_company.payment_plan_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Company.REFERENCE_Company);

                if (objectToReturn instanceof Company)
                {
                    LogMgr.log (CompanyPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Company");
                }
            }

            PersistentSet tl_companyPSet = allPSets.getPersistentSet(id, "tl_company", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_companyPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_companyPSet.containsAttrib(Company.FIELD_CompanyName)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_CompanyLogo)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_HiringTeamType)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_Industry)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_TimeZone)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_IsVerified)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_State)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_Country)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_PostCode)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_City)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_HasClientSupport)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_StripeReference)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_StripeSubscription)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_NameOnCard)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_CardPostCode)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_CardID)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_PlanRenewedOn)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_UsedCredits)||
                    !tl_companyPSet.containsAttrib(Company.FIELD_CompanyStatus)||
                    !tl_companyPSet.containsAttrib(Company.SINGLEREFERENCE_AddedByUser)||
                    !tl_companyPSet.containsAttrib(Company.SINGLEREFERENCE_PaymentPlan))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CompanyPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                Company result = new Company ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_company " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_company.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_companyPSet = allPSets.getPersistentSet(objectID, "tl_company");
            

            
            if (tl_companyPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_companyPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_company " +
                                                           "SET company_name = ?, company_logo = ?, hiring_team_type = ?, industry = ?, time_zone = ?, is_verified = ?, state = ?, country = ?, post_code = ?, city = ?, has_client_support = ?, stripe_reference = ?, stripe_subscription = ?, name_on_card = ?, card_post_code = ?, card_id = ?, plan_renewed_on = ?, used_credits = ?, company_status = ?, added_by_user_id = ? , payment_plan_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_company.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_CompanyName.getForSQL(dummyCompanyName, tl_companyPSet.getAttrib (Company.FIELD_CompanyName))).listEntry (HELPER_CompanyLogo.getForSQL(dummyCompanyLogo, tl_companyPSet.getAttrib (Company.FIELD_CompanyLogo))).listEntry (HELPER_HiringTeamType.getForSQL(dummyHiringTeamType, tl_companyPSet.getAttrib (Company.FIELD_HiringTeamType))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_companyPSet.getAttrib (Company.FIELD_Industry))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_companyPSet.getAttrib (Company.FIELD_TimeZone))).listEntry (HELPER_IsVerified.getForSQL(dummyIsVerified, tl_companyPSet.getAttrib (Company.FIELD_IsVerified))).listEntry (HELPER_State.getForSQL(dummyState, tl_companyPSet.getAttrib (Company.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_companyPSet.getAttrib (Company.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_companyPSet.getAttrib (Company.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_companyPSet.getAttrib (Company.FIELD_City))).listEntry (HELPER_HasClientSupport.getForSQL(dummyHasClientSupport, tl_companyPSet.getAttrib (Company.FIELD_HasClientSupport))).listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_companyPSet.getAttrib (Company.FIELD_StripeReference))).listEntry (HELPER_StripeSubscription.getForSQL(dummyStripeSubscription, tl_companyPSet.getAttrib (Company.FIELD_StripeSubscription))).listEntry (HELPER_NameOnCard.getForSQL(dummyNameOnCard, tl_companyPSet.getAttrib (Company.FIELD_NameOnCard))).listEntry (HELPER_CardPostCode.getForSQL(dummyCardPostCode, tl_companyPSet.getAttrib (Company.FIELD_CardPostCode))).listEntry (HELPER_CardID.getForSQL(dummyCardID, tl_companyPSet.getAttrib (Company.FIELD_CardID))).listEntry (HELPER_PlanRenewedOn.getForSQL(dummyPlanRenewedOn, tl_companyPSet.getAttrib (Company.FIELD_PlanRenewedOn))).listEntry (HELPER_UsedCredits.getForSQL(dummyUsedCredits, tl_companyPSet.getAttrib (Company.FIELD_UsedCredits))).listEntry (HELPER_CompanyStatus.getForSQL(dummyCompanyStatus, tl_companyPSet.getAttrib (Company.FIELD_CompanyStatus))).listEntry (SQLManager.CheckNull((Long)(tl_companyPSet.getAttrib (Company.SINGLEREFERENCE_AddedByUser)))).listEntry (SQLManager.CheckNull((Long)(tl_companyPSet.getAttrib (Company.SINGLEREFERENCE_PaymentPlan)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_company WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_company", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CompanyPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_company");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_company for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CompanyPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_companyPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CompanyPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_companyPSet = allPSets.getPersistentSet(objectID, "tl_company");
        

        LogMgr.log (CompanyPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_companyPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_companyPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_company " +
                                                       "WHERE tl_company.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_company WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_company");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_company for row:" + objectID;

                    LogMgr.log (CompanyPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_companyPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Company> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Company.REFERENCE_Company.getObjectIDSpace (), r.getLong ("id"));
            Company resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Company.REFERENCE_Company);

                if (cachedElement instanceof Company)
                {
                    LogMgr.log (CompanyPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Company)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Company");
                }
            }
            else
            {
                PersistentSet tl_companyPSet = allPSets.getPersistentSet(objectID, "tl_company", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new Company ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CompanyPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_company " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (Company.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_company.object_id is not null
                    String preFilter = "(tl_company.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_company " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_companyPSet = allPSets.getPersistentSet(objectID, "tl_company", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_companyPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_companyPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_companyPSet.setAttrib(Company.FIELD_CompanyName, HELPER_CompanyName.getFromRS(dummyCompanyName, r, "company_name"));
        tl_companyPSet.setAttrib(Company.FIELD_CompanyLogo, HELPER_CompanyLogo.getFromRS(dummyCompanyLogo, r, "company_logo"));
        tl_companyPSet.setAttrib(Company.FIELD_HiringTeamType, HELPER_HiringTeamType.getFromRS(dummyHiringTeamType, r, "hiring_team_type"));
        tl_companyPSet.setAttrib(Company.FIELD_Industry, HELPER_Industry.getFromRS(dummyIndustry, r, "industry"));
        tl_companyPSet.setAttrib(Company.FIELD_TimeZone, HELPER_TimeZone.getFromRS(dummyTimeZone, r, "time_zone"));
        tl_companyPSet.setAttrib(Company.FIELD_IsVerified, HELPER_IsVerified.getFromRS(dummyIsVerified, r, "is_verified"));
        tl_companyPSet.setAttrib(Company.FIELD_State, HELPER_State.getFromRS(dummyState, r, "state"));
        tl_companyPSet.setAttrib(Company.FIELD_Country, HELPER_Country.getFromRS(dummyCountry, r, "country"));
        tl_companyPSet.setAttrib(Company.FIELD_PostCode, HELPER_PostCode.getFromRS(dummyPostCode, r, "post_code"));
        tl_companyPSet.setAttrib(Company.FIELD_City, HELPER_City.getFromRS(dummyCity, r, "city"));
        tl_companyPSet.setAttrib(Company.FIELD_HasClientSupport, HELPER_HasClientSupport.getFromRS(dummyHasClientSupport, r, "has_client_support"));
        tl_companyPSet.setAttrib(Company.FIELD_StripeReference, HELPER_StripeReference.getFromRS(dummyStripeReference, r, "stripe_reference"));
        tl_companyPSet.setAttrib(Company.FIELD_StripeSubscription, HELPER_StripeSubscription.getFromRS(dummyStripeSubscription, r, "stripe_subscription"));
        tl_companyPSet.setAttrib(Company.FIELD_NameOnCard, HELPER_NameOnCard.getFromRS(dummyNameOnCard, r, "name_on_card"));
        tl_companyPSet.setAttrib(Company.FIELD_CardPostCode, HELPER_CardPostCode.getFromRS(dummyCardPostCode, r, "card_post_code"));
        tl_companyPSet.setAttrib(Company.FIELD_CardID, HELPER_CardID.getFromRS(dummyCardID, r, "card_id"));
        tl_companyPSet.setAttrib(Company.FIELD_PlanRenewedOn, HELPER_PlanRenewedOn.getFromRS(dummyPlanRenewedOn, r, "plan_renewed_on"));
        tl_companyPSet.setAttrib(Company.FIELD_UsedCredits, HELPER_UsedCredits.getFromRS(dummyUsedCredits, r, "used_credits"));
        tl_companyPSet.setAttrib(Company.FIELD_CompanyStatus, HELPER_CompanyStatus.getFromRS(dummyCompanyStatus, r, "company_status"));
        
        tl_companyPSet.setAttrib(Company.SINGLEREFERENCE_AddedByUser, r.getObject ("added_by_user_id"));
        tl_companyPSet.setAttrib(Company.SINGLEREFERENCE_PaymentPlan, r.getObject ("payment_plan_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_companyPSet = allPSets.getPersistentSet(objectID, "tl_company");
        

        
        if (tl_companyPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_companyPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_company " +
                                     "  (company_name, company_logo, hiring_team_type, industry, time_zone, is_verified, state, country, post_code, city, has_client_support, stripe_reference, stripe_subscription, name_on_card, card_post_code, card_id, plan_renewed_on, used_credits, company_status,  added_by_user_id, payment_plan_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_CompanyName.getForSQL(dummyCompanyName, tl_companyPSet.getAttrib (Company.FIELD_CompanyName))).listEntry (HELPER_CompanyLogo.getForSQL(dummyCompanyLogo, tl_companyPSet.getAttrib (Company.FIELD_CompanyLogo))).listEntry (HELPER_HiringTeamType.getForSQL(dummyHiringTeamType, tl_companyPSet.getAttrib (Company.FIELD_HiringTeamType))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_companyPSet.getAttrib (Company.FIELD_Industry))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_companyPSet.getAttrib (Company.FIELD_TimeZone))).listEntry (HELPER_IsVerified.getForSQL(dummyIsVerified, tl_companyPSet.getAttrib (Company.FIELD_IsVerified))).listEntry (HELPER_State.getForSQL(dummyState, tl_companyPSet.getAttrib (Company.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_companyPSet.getAttrib (Company.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_companyPSet.getAttrib (Company.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_companyPSet.getAttrib (Company.FIELD_City))).listEntry (HELPER_HasClientSupport.getForSQL(dummyHasClientSupport, tl_companyPSet.getAttrib (Company.FIELD_HasClientSupport))).listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_companyPSet.getAttrib (Company.FIELD_StripeReference))).listEntry (HELPER_StripeSubscription.getForSQL(dummyStripeSubscription, tl_companyPSet.getAttrib (Company.FIELD_StripeSubscription))).listEntry (HELPER_NameOnCard.getForSQL(dummyNameOnCard, tl_companyPSet.getAttrib (Company.FIELD_NameOnCard))).listEntry (HELPER_CardPostCode.getForSQL(dummyCardPostCode, tl_companyPSet.getAttrib (Company.FIELD_CardPostCode))).listEntry (HELPER_CardID.getForSQL(dummyCardID, tl_companyPSet.getAttrib (Company.FIELD_CardID))).listEntry (HELPER_PlanRenewedOn.getForSQL(dummyPlanRenewedOn, tl_companyPSet.getAttrib (Company.FIELD_PlanRenewedOn))).listEntry (HELPER_UsedCredits.getForSQL(dummyUsedCredits, tl_companyPSet.getAttrib (Company.FIELD_UsedCredits))).listEntry (HELPER_CompanyStatus.getForSQL(dummyCompanyStatus, tl_companyPSet.getAttrib (Company.FIELD_CompanyStatus))) .listEntry (SQLManager.CheckNull((Long)(tl_companyPSet.getAttrib (Company.SINGLEREFERENCE_AddedByUser)))).listEntry (SQLManager.CheckNull((Long)(tl_companyPSet.getAttrib (Company.SINGLEREFERENCE_PaymentPlan)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_companyPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
