export const CLASSES = {
    MESSAGE_TEMPLATE: 'performa.orm.MessageTemplate',
    TEMPLATE_TYPE: 'performa.orm.types.TemplateType',
    APPLICATION_STATUS: 'performa.orm.types.ApplicationStatus',
    HIRING_TEAM: 'performa.orm.HiringTeam',
    PLACEHOLDER_OPTIONS: 'performa.orm.types.PlaceholderOptions',
    WORKFLOW_TEMPLATE: 'performa.orm.WorkFlowTemplate',
    WORKFLOW_MESSAGE: 'performa.orm.WorkFlowMessage',
    WORKFLOW_STAGE: 'performa.orm.WorkFlowStage',
    WORKFLOW_STEP: 'performa.orm.WorkFlowStep',
    JOB_APPLICATION: 'performa.orm.JobApplication',
    MESSAGE: 'performa.orm.Message',
    CHAT_ATTACHMENT: 'performa.orm.ChatAttachment',
    CANDIDATE: 'performa.orm.Candidate',
    USER: 'oneit.security.SecUser',
    JOB: 'performa.orm.Job',
    CAREER_PROFILE: 'performa.orm.CareerProfile',
    WORK_STYLE_QUESTION: 'performa.orm.WorkStyleQuestionNP',
    WORK_PREFERENCE_QUESTION: 'performa.orm.WorkPreferencesQuestionNP',
    DIVERSITY_QUESTION: 'performa.orm.DiversityQuestion',
    DIVERSITY_ANSWER: 'performa.orm.DiversityAnswer',
    WORK_EXPERIENCE: 'performa.orm.WorkExperience',
    CERTIFICATION: 'performa.orm.Certification',
    EDUCATION: 'performa.orm.EducationCertificate',
    QUESTION: 'performa.orm.Question',
    CAREER_SKILL: 'performa.orm.CareerProfileSkill',
    SKILL: 'performa.orm.Skill',
    REFEREE: 'performa.orm.Referee',
    CandidateTemplate: 'performa.orm.CandidateTemplate',
    INTRO: 'performa.orm.IntroductionLetter',
    ILWorkExperience: 'performa.orm.ILWorkExperience',
    ILSkill: 'performa.orm.ILSkill',
    Job: 'performa.orm.Job',
};

export const SERVICES = {
    MESSAGE_TEMPLATES: 'MessageTemplates',
    WORKFLOW_TEMPLATES: 'WorkFlowTemplates',
    SAVE_MESSAGE_AS_COPY: 'SaveMessageAsCopy',
    SAVE_WORKFLOW_AS_COPY: 'SaveWorkflowAsCopy',
    SAVE_WORKFLOW: 'SaveWorkFlowTemplate',
    SAVE: 'Save',
    CAREER_PROFILES: 'CareerProfiles',
    JOB_TITLES: 'JobTitles',
    SKILLS: 'Skills',
    EMPLOYERS: 'Employers',
    CERTIFICATIONS: 'Certifications',
    LOGIN_LINKEDIN: 'LoginWithLinkedIn',
    LOGIN_GOOGLE: 'LoginWithGoogle',
    INTRODUCTION_LETTERS: 'IntroductionLetters',
    APPLICANT_TALENT_JOBS: 'ApplicantTalentJobs',
};

export const SEARCH = {
    MESSAGE_TEMPLATE: 'ListMessageTemplate',
    WORKFLOW_TEMPLATE: 'ListWorkFlow'
};

export const ASSOCS = {
    WORKFLOW_STAGE: 'WorkFlowStages',
    WORKFLOW_MESSAGE: 'WorkFlowMessages',
    WORKFLOW_STEP: 'Steps',
    MESSAGE_TEMPLATE: 'MessageTemplate',
    JOB: 'Job',
    CANDIDATE: 'Candidate',
    USER: 'User',
    MESSAGES: 'Messages',
    HIRING_TEAM: 'HiringTeam',
    SENT_BY: 'SentBy',
    ATTACHMENTS: 'Attachments'
};


export const EXTERNAL_LINKS = {
    TERMS_CONDITIONS: 'https://www.matchd.com/career-terms',
    PRIVACY_POLICY: 'https:/www.matchd.com/privacy',
};


export const PROFILE_TASKS = [
    {
        label: 'Personal Details',
        text: 'We need some information from you so that you can fill out your Career Profile.',
        firstTime: 'We need some information from you so you can fill out your career profile and get job hunting.',
        button: 'I’m ready to get started',
        firstTimeBtn: 'Get Started',
        link: '/my-career-web/dashboard/personal-details',
        key: 'CompletedPercentage',
        inProgress: false,
        completed: false,
        started: false
    },
    {
        label: 'Work Strengths',
        text: 'Complete the Work Strengths questionnaire to find out your individual work strengths.',
        button: 'Do the questionnaire',
        link: '/my-career-web/assessments/work-style',
        key: 'CompletedPercentageWS',
        inProgress: false,
        completed: false,
        allowEditField: 'AllowResubmitWS',
        started: false
    },
    {
        label: 'Career Values',
        text: 'Now complete the Career Values questionnaire to create your values profile.',
        button: 'Do the questionnaire',
        link: '/my-career-web/assessments/work-preference',
        key: 'CompletedPercentageWP',
        inProgress: false,
        completed: false,
        allowEditField: 'AllowResubmitWP',
        started: false
    },
    {
        label: 'Career History',
        text: 'Add your work, education and experience to finish your Career Profile.',
        button: 'Add career history',
        link: '/my-career-web/career-history/personal-data',
        key: 'CompletedPercentageCH',
        inProgress: false,
        completed: false,
        started: false
    },
    {
        label: 'Diversity',
        text: 'Include your diversity profile for employers that use affirmative action policy.',
        button: 'Update my profile',
        link: '/my-career-web/assessments/diversity-profile',
        key: 'CompletedPercentageDiv',
        inProgress: false,
        completed: false,
        started: false
    }
];

export const CAREER_TABS = {
    PERSONAL_DATA: 'PERSONAL_DATA',
    WORK_HISTORY: 'WORK_HISTORY',
    EDUCATION: 'EDUCATION',
    SKILLS: 'SKILLS',
    REFERENCES: 'REFERENCES',
    TEMPLATES: 'TEMPLATES',
    PUBLISH: 'PUBLISH'
};
