package performa.utils;

import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.business.content.jsp.*;
import oneit.objstore.ObjectTransaction;


public class PerformaArticleUtil
{
    public static final String ADMIN_PORTAL     = "AdminPortal";
    public static final String APPLICANT_PORTAL = "ApplicantPortal";
    public static final String ADMIN_HOME       = "AdminHome";
    public static final String APPLICANT_HOME   = "ApplicantHome";
    
    public static boolean descendsFrom (Article article, String parentArticleIdFilter)
    {
        if (article.getIdentifier ().equals (parentArticleIdFilter))
        {
            return true;
        }
        else if (article.getCategory () != null && article.getCategory () != article)
        {
            return descendsFrom(article.getCategory (), parentArticleIdFilter);
        }
        else
        {
            return false;
        }
    }
    
    public static String getPortalName(ObjectTransaction objTran, Article article, Article applicantArticle, Article adminArticle)
    {   
        if(applicantArticle != null)
        {
            if(descendsFrom(article, applicantArticle.getIdentifier()))
            {
                return APPLICANT_PORTAL;
            }
        }
        
        if(adminArticle != null)
        {
            if(descendsFrom(article, adminArticle.getIdentifier()))
            {
                return ADMIN_PORTAL;
            }
        }
        
        return "";
    }
    
    public static Article getArticleByShortCut(ObjectTransaction objTran, String shortCut)
    {
        return ShortcutFilter.doShortcutSearch(objTran, shortCut);
    }
    
    public static String getEventLink(Article eventArticle, HttpServletRequest request, Long eventID)
    {
        if(eventArticle != null)
        {
            return eventArticle.getLink(request) + "?EventID=" + eventID; 
        }
        
        return "";
    }
}
