import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { EditWorkflowTemplateService } from './edit-workflow-template.service';

import { WorkflowTemplate } from './edit-workflow-template.model';

@Component({
    selector: 'app-edit-workflow-template',
    templateUrl: './edit-workflow-template.component.html'
})
export class EditWorkflowTemplateComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    workflowTemplate = new WorkflowTemplate();
    s: any[] = [];
    messagetemplates: any[] = [];
    s: any[] = [];
    messagetemplates: any[] = [];
    messagetemplate_withdraws: any[] = [];
    messagetemplates: any[] = [];
    messagetemplates: any[] = [];
    messagetemplate_withdraws: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private editWorkflowTemplateService: EditWorkflowTemplateService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getWorkflowTemplateByID(params.id);
                    } else {
                        this.utilsService.createObject(this.workflowTemplate, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
        this.gets();
        this.gets();
    }
    

    gets() {
        this.subscriptions.push(this.editWorkflowTemplateService.getDummy455s([])
            .subscribe(
                data => {
                    this.s = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplatesForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplates = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    gets() {
        this.subscriptions.push(this.editWorkflowTemplateService.getDummy459s([])
            .subscribe(
                data => {
                    this.s = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplatesForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplates = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate_withdraw(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplate_withdrawsForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplate_withdraws = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplatesForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplates = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplatesForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplates = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    autoCompleteMessagetemplate_withdraw(event) {
        this.subscriptions.push(this.editWorkflowTemplateService.getmessagetemplate_withdrawsForAutocomplete(event.query, [])
            .subscribe(
                data => {
                    for(let obj of data){
                        //If you need to display anything complex in autocomplete label, put that code here 
                        //e.g. obj.Name = obj.FirstName + ' ' + obj.LastName. So that you can use "Name" attribute in HTML
                    }
                    this.messagetemplate_withdraws = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    getWorkflowTemplateByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.editWorkflowTemplateService.getWorkflowTemplateByID(id, assocs)
            .subscribe(
                data => {
                    this.workflowTemplate = data;
                    this.updatedObjs[this.workflowTemplate.ObjectID] = this.workflowTemplate;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveWorkflowTemplate(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.workflowTemplate.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/edit-workflow-template", idToNavigate]);
                                return;
                            }
                            this.getWorkflowTemplateByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}