package performa.orm;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.objstore.rdbms.filters.GreaterThanFilter;
import oneit.objstore.rdbms.filters.LessThanFilter;
import oneit.objstore.utils.ObjstoreUtils;
import oneit.utils.CollectionUtils;
import oneit.utils.ObjectTransform;
import oneit.utils.filter.CollectionFilter;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.orm.types.AssessmentType;
import performa.orm.types.CriteriaType;


public class AssessmentCriteriaTemplate extends BaseAssessmentCriteriaTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public AssessmentCriteriaTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    

    @Override
    public String getToString() 
    {
        return getTemplateName();
    }
    
    public List<WorkFlow> getSortedMiddleWorkFlows()
    {
        Filter<WorkFlow>    filter  =   WorkFlow.SearchByAll().andSortOrder(new LessThanFilter<>(9)).andSortOrder(new GreaterThanFilter<>(1));
        
        return ObjstoreUtils.sort(pipelineAssessmentCriteriaTemplate().toWorkFlows(filter).uniqueVals(), 
                                                                        new ObjectTransform[]{WorkFlow.pipesWorkFlow().toSortOrder()}, 
                                                                        new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});
    }
    
    public WorkFlow getWorkFlowBySortOrder(int sortOrder)
    {
        Filter<WorkFlow>    filter  =   WorkFlow.SearchByAll().andSortOrder(new EqualsFilter<>(sortOrder));
        
        return pipelineAssessmentCriteriaTemplate().toWorkFlows(filter).val();
    } 
    
    public String getLevelClass(Level level)
    {
        if(!showLevelOption(level))
        {
            return "hide";
        }
        
        if(CollectionUtils.equals(level, getLevel()))
        {
            return "active";
        }
        return "";
    }
    
    public boolean showLevelOption(Level level)
    {
        if(isExpressJob())
        {
            return isTrue(level.getAppliedToExpress());
        }
        return !isTrue(level.getAppliedToExpress());
    }
    
    public boolean isExpressJob()
    {
        return getAssessmentType() == AssessmentType.EXPRESS;
    }
    
    public boolean showAssessmentCriteriaSection()
    {
        return isTrue(getIncludeAssessmentCriteria());
    }
    
    public Collection<AssessmentCriteria> getAssessmentCriteraByType(CriteriaType criteria)
    {
        Filter  filter  = AssessmentCriteria.SearchByAll().andCriteriaType(new EqualsFilter<>(criteria));   

        return  CollectionFilter.filter(getAssessmentCriteriasSet(), filter);
    }
    
    public int getAssessmentCriteraCountByType(CriteriaType criteria)
    {
        return getAssessmentCriteraByType(criteria).size();
    }
    
    @Override
    protected void postILOJobTitleChange() throws FieldException
    {
        Occupation  occupation  =   getILOJobTitle() != null ? getILOJobTitle().getOccupation() : null;
        
        if(occupation != null)
        {
            setOccupation(occupation);
            setLevel(occupation.getAssessmentLevel());
            setAssessmentType(occupation.getAssessmentType());
        }
        
        super.postILOJobTitleChange(); 
    }
    
    public Occupation displayOccupation()
    {
        return getOccupation();
    }

}