<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String          nextPage        =   WebUtils.getSamePageInRenderMode(request, "ManagePlan");
    SecUser         loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser     companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company         company         =   companyUser.getCompany();

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    PaymentPlan[]   plans           =   Utils.getPaymentPlansForJobs(transaction);
    Integer         maxCount        =   0;
    Integer         minCount        =   0;
    
    if(company.getPaymentPlan()!=null && company.getPaymentJobCount()==null)
    {
        company.setPaymentJobCount(company.getPaymentPlan().getActiveJobCount());
    }
    
    if(plans.length>0)
    {
        Collection<Integer> jCounts =   PaymentPlan.pipesPaymentPlan(plans).toActiveJobCount().vals();
        maxCount                    =   Collections.max(jCounts);
        minCount                    =   Collections.min(jCounts);
    }

%>
    <script type="text/javascript">
        $(document).ready(function()
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
            
            $("#upload").change(function(){
                readURL(this);
            });

            $("#remove-logo").click(function(){
                removeLogo();
            });
            
            validate();
            
            $('input').on('change keyup', function() { validate() });
        });
        
        function validate() {
            var empty = false;
            $('input[required]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                }
            });

            if (empty) {
                $('.save-btn').attr('disabled', 'disabled');
            } else {
                $('.save-btn').removeAttr('disabled');
            }
        }
    </script>    
    
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title">My Hiring Team</h1>
                <div class="my-company-area">
                    <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>
                        
                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <%
                                        if(company.getPaymentPlan()==null)
                                        {
                                    %>
                                            <div class="tabpage-title">
                                                <label class="label-20">No Current Plan</label><br/>               
                                                <label class="label-14">You'll be charged each time you add a new job</label>                
                                                <div class="line-break"></div>
                                            </div>

                                            <div>
                                                <label class="label-20">Talentology Subscription</label>
                                            </div>
                                            <div class="grey-area payment-grey-area">
                                                
                                                <div class="text-center">
                                                    <label class="label-20">Subscribe and save</label>
                                                </div>
                                                
                                                <div class="a-label-row payment-type-row">
                                                    <div class="col-md-6 col-sm-6 col-xs-6 text-right">
                                                        <div class="active-jobs-per-mont">
                                                            Active Jobs Per Month
                                                        </div>
                                                        <oneit:ormInput type="number"           obj="<%= company %>"  attributeName="PaymentJobCount"   required="true"
                                                                        min="<%= minCount %>"   max="<%= maxCount %>" step="1"  cssClass="payment-paln-count"/>
                                                    </div>
                                                    <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                                                        <oneit:recalcClass  htmlTag="span"  classScript="company.getPerJobPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
                                                            <div >
                                                                <span class="payment-amt text-right">
                                                                    <oneit:recalc   mode="Currency" script="company.getPerJobPaymentPlanAmount()"   company="<%= company %>"  nullValue=""/>
                                                                </span>
                                                                <span class="text-left">
                                                                    <p class="per-job">
                                                                    Per Job
                                                                    </p>                                                            </div>

                                                                </span>
                                                        </oneit:recalcClass>

                                                    </div>
                                                </div>

                                                <div class="a-label-row text-center">
                                                    <oneit:button   value="Upgrade"     name="saveCompany"      cssClass="btn btn-primary largeBtn btn-green save-btn"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                        .mapEntry ("Company", company)
                                                                                                        .mapEntry ("IsPayment", Boolean.TRUE)
                                                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("Company"))
                                                                                                        .toMap() %>" />
                                                </div>
                                                
                                                <oneit:recalcClass  htmlTag="span"  classScript="company.getPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
                                                    <div class="a-label-row text-center">
                                                        <div class="col-md-3 col-sm-3 col-xs-3">
                                                        </div>
                                                        <div class="col-md-6 col-sm-6 col-xs-6 payment-job-det text-center">
                                                            <oneit:toString value="<%= PaymentPlan.PER_PER_JOB_AMOUNT %>" mode="Currency"/>
                                                             Monthly for up to
                                                            <oneit:recalc   mode="EscapeHTML"   script="company.getPaymentJobCount()"       company="<%= company %>"    nullValue=""/>
                                                             jobs / month 
                                                            Save 
                                                            <oneit:recalc   mode="Currency"     script="company.getPaymentPlanSaveAmount()" company="<%= company %>"    nullValue=""/>
                                                             per month
                                                        </div>
                                                        <div class="col-md-3 col-sm-3 col-xs-3">
                                                        </div>
                                                    </div>
                                                </oneit:recalcClass>
                                                
                                                <div class="a-label-row">&nbsp;</div>
                                            </div>
                                    <%
                                        }
                                        else
                                        {
                                    %>
                                            <div class="tabpage-title">
                                                <label class="label-20">Current Plan</label><br/>               
                                                <label class="label-14">View and edit your subscription </label>                
                                                <div class="line-break"></div>
                                            </div>
                                            
                                            <div class="a-label-row pay-subsc-row">
                                                <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                                                    <label class="label-20 pay-subsc-txt">Talentology Subscription</label>
                                                </div>
                                                <div class="col-md-6 col-sm-6 col-xs-6 text-right">
                                                    <oneit:ormInput type="number"           obj="<%= company %>"  attributeName="PaymentJobCount"   required="true"
                                                                    min="<%= minCount %>"   max="<%= maxCount %>" step="1"  cssClass="payment-paln-count"/>
                                                     <label class="label-20">&nbsp;Jobs / month </label>    
                                                </div>
                                            </div>
                                                     
                                            <div class="pay-subsc-det-row a-label-row">
                                                <oneit:recalcClass  htmlTag="span"  classScript="company.getPaymentPlanAmount()!=null ? 'show': 'hide'" company="<%= company %>">
                                                    <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                                                        Total: 
                                                        <span class="pay-subsc-amt">
                                                            <oneit:recalc   mode="Currency"     script="company.getPaymentPlanAmount()" company="<%= company %>"    nullValue=""/>
                                                             / mo
                                                        </span>
                                                    </div>
                                                    <div class="col-md-6 col-sm-6 col-xs-6 text-right pay-subsc-det">
                                                        <div class="text-right">
                                                            <oneit:recalc   mode="Currency" script="company.getPerJobPaymentPlanAmount()"   company="<%= company %>"  nullValue=""/> 
                                                            per job. Save 
                                                            <oneit:recalc   mode="Currency"     script="company.getPaymentPlanSaveAmount()" company="<%= company %>"    nullValue=""/> 
                                                            per month.
                                                        </div>
                                                    </div>
                                                </oneit:recalcClass>
                                            </div>
                                                                
                                            <div class="a-label-row text-center pay-subsc-btn-row">
                                                <oneit:button   value="Update Subscription" name="saveCompany"      cssClass="btn btn-primary largeBtn btn-green save-btn"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                    .mapEntry ("Company", company)
                                                                                                    .mapEntry ("IsPayment", Boolean.TRUE)
                                                                                                    .mapEntry ("attribNamesToRestore", Collections.singleton("Company"))
                                                                                                    .toMap() %>" />
                                            </div>
                                            
                                            <div class="line-break"></div>
                                    <%
                                    
                                        }
                                    %>
                                    
                                    <div class="text-center footer-note">
                                        Looking to cancel your account? Please <a href="http://www.talentology.com/">contact us.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </oneit:form>
                </div>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
