<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<oneit:dynIncluded>
<%
    String      nextPage    =    WebUtils.getSamePageInRenderMode(request, "CompanyProfile");
    CompanyUser companyUser =   (CompanyUser) process.getAttribute("CompanyUser");
    SecUser     secUser     =   null;
    Boolean     socialLogin =   Boolean.FALSE;
    
    //to process company user verification
    String      id          =   request.getParameter("id");
    String      key         =   request.getParameter("key");
    Boolean     invalid     =   Boolean.TRUE;
    
    if(id!=null && key!=null)
    {
        companyUser =   CompanyUser.searchIdPin(transaction, Long.parseLong(id), key);

        if(companyUser!=null && companyUser.getIsAccountVerified()!=Boolean.TRUE)
        {
            secUser =   companyUser.getUser();
            process.setAttribute("CompanyUser", companyUser);
            
            invalid =   Boolean.FALSE;
        }
    }
    
    if(invalid)
    {
        //to handle social login
        SecUser     logedInUser =   SecUser.getTXUser(transaction);
        companyUser             =   logedInUser != null ? logedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser) : null;
        
        if(logedInUser!=null  
                && logedInUser.hasRole(Utils.ROLE_CLIENT) 
                && companyUser!=null 
                && companyUser.getIsAccountVerified()!=Boolean.TRUE)
        {
            socialLogin =   Boolean.TRUE;
        }
        else
        {
            response.sendRedirect(WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME).getLink(request));
        }
    }
    
    Debug.assertion(companyUser != null, "Invalid CompanyUser in admin portal");
%>
    <script type="text/javascript">
        $(document.body).addClass('bg-color');

        $(document).ready(function() {
            validate();
            $('input').on('change keyup', function() { validate() });
            interval =  setInterval(function() { validate(); }, 500);
        });

        function validate() {
            var empty = false;
            $('input[required]').each(function() {
                if ($( this ).val() == '') {
                    empty = true;
                    if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                       empty = false;
                    }
                }
            });
 
            if (empty) {
                $('.verify-btn').attr('disabled', 'disabled');
            } else {
                $('.verify-btn').removeAttr('disabled');
                 clearInterval(interval);
            }
        }
    </script>
    
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
    </style>

    <oneit:form name="verify"    method="post">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="main-box-layout login-box">
            <oneit:dynInclude   page="/extensions/adminportal/inc/company_user_data.jsp"    data="<%= CollectionUtils.EMPTY_MAP%>"  CompanyUser="<%= companyUser %>"/>
            
            <%
                if(!socialLogin)
                {
            %>
                    <div class="form-group text-left">
                        <label>Password</label>
                        <oneit:ormInput obj="<%= companyUser %>"    type="password" attributeName="Password"        cssClass="form-control second-style reset-pw"    required="true"/>
                    </div>
                    <div class="form-group text-left">
                        <label>Confirm password</label>
                        <oneit:ormInput obj="<%= companyUser %>"    type="password" attributeName="ConfirmPassword" cssClass="form-control second-style reset-pw "   required="true"/>
                    </div>
            <%
                }
            %>
            
            <oneit:button   value="Verify and login"    name="verifyCompanyUser"    cssClass="box-btn verify-btn"
                            requestAttribs="<%= CollectionUtils.mapEntry("socialLogin", socialLogin)
                                                            .mapEntry("nextPage", nextPage).toMap() %>"/>
        </div>
    </oneit:form>
</oneit:dynIncluded>
        
<%@ include file="inc/htmlfooter_nopriv.jsp" %>