import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AuthModule } from './auth/auth.module';
import { DashboardModule } from './dashboard/dashboard.module';
import { HomeGuard } from './guards/home.guard';
import { PublicGuard } from './guards/public.guard';
import { WrapperComponent } from './layouts/wrapper/wrapper.component';
import { WelcomeComponent } from './welcome/welcome.component';

const routes: Routes = [
    {
        path: '',
        component: WrapperComponent,
        children: [
            {
                path: 'auth',
                // @ts-ignore
                // tslint:disable-next-line:newline-per-chained-call
                loadChildren: () => import('./auth/auth.module').then(() => AuthModule),
                canActivate: [PublicGuard]
            },
            {
                path: 'dashboard',
                // @ts-ignore
                // tslint:disable-next-line:newline-per-chained-call
                loadChildren: () => import('./dashboard/dashboard.module').then(() => DashboardModule),
                canActivate: [HomeGuard]
            },
            {path: '', component: WelcomeComponent, canActivate: [PublicGuard]}
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class MyCareerWebRouting {
}
