<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    SecUser     loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company     company         =   companyUser.getCompany();

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    String      nextPage        =   WebUtils.getSamePageInRenderMode(request, "Page");
%>
    <script src="https://js.stripe.com/v3/"></script>
    <script>
        var stripePubKey = '<%= MakePaymentFP.STRIPE_PUB_KEY %>';
    </script>
    <oneit:script>
        <!-- MUST be included after initializing stripePubKey -->
        <oneit:script src="/scripts/performaStripe.js"/>
    </oneit:script>
    <script type="text/javascript">
        $(document).ready(function()
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
    </script>    
    
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <h1 class="page-title">My Hiring Team</h1>
                <div class="my-company-area">
                    <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>
                        
                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="3"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="company-detail">
                                    <div class="tabpage-title">
                                        <label class="label-20">Billing</label>               
                                    </div>
                                    <div>
                                        <label class="label-14 bold">Add a payment method</label><br/>           
                                        <label class="label-14">Your card details will be saved for future billing</label>            
                                    </div>
                                    <div class="grey-area">
                                        <div class="form-group hide">
                                            <input type="hidden" name="stripe-token-id" />
                                        </div>
                                        <div class="form-group">
                                            <label>Card Number</label>
                                            <oneit:ormInput obj="<%= company %>"    type="text" attributeName="CompanyName" cssClass="form-control" />                                
                                        </div>
                                        <div class="form-group">
                                            <label>Name on Card</label>
                                            <oneit:ormInput obj="<%= company %>"    type="text" attributeName="CompanyName" cssClass="form-control" />                                
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <label>Expires</label>
                                                <oneit:ormEnum  obj="<%= company %>"    attributeName="Country" cssClass="form-control"/>
                                            </div>
                                            <div class="col-md-4">
                                                <label>CCV</label>
                                                <oneit:ormEnum  obj="<%= company %>"    attributeName="State" cssClass="form-control"/>
                                            </div>
                                            <div class="col-md-4">
                                                <label>Postal Code</label>
                                                <oneit:ormInput obj="<%= company %>"    type="text" attributeName="PostCode"    cssClass="form-control" />      
                                            </div>
                                        </div>  
                                        <div class="form-group">
                                            <oneit:button   value="Save Card"     name="saveCompany"  cssClass="btn btn-primary btn-green large-btn"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                .mapEntry("Company", company)
                                                                                                .toMap() %>" />
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
    <form action="/charge" method="post" id="payment-form">
        <div class="form-row">
            <label for="card-element">
                Credit or debit card
            </label>
            <div id="card-element">
                 a Stripe Element will be inserted here. 
            </div>

             Used to display Element errors 
            <div id="card-errors" role="alert"></div>
        </div>

        <button>Submit Payment</button>
    </form>
                    </oneit:form>
                </div>
            </div>
        </div>
    </div>
</oneit:dynIncluded>
