package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.utils.NotificationUtils;
import oneit.utils.*;
import performa.orm.CompanyUser;
import performa.orm.CultureCriteria;
import performa.orm.CultureCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class SaveCultureTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside SaveCultureTemplateFP for create new template for ", job);
        
        String messageId = NotificationUtils.getNotifyIdIfRequired(process, request);
        
        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            CultureCriteriaTemplate newTemplate =   CultureCriteriaTemplate.createCultureCriteriaTemplate(newObjTran);
            SecUser                 secUser     =   SecUser.getTXUser(newObjTran);
            CompanyUser             companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
            
            newTemplate.setCompanyUser(companyUser);
            newTemplate.setClient(job.getClient() != null ? job.getClient().getInTransaction(newObjTran) : null );
            newTemplate.setHiringTeam(job.getHiringTeam().getInTransaction(newObjTran));
            newTemplate.setTemplateName(job.getCultureTemplateName());
            newTemplate.setCultureStatement(job.getCultureStatement());
            
            for(CultureCriteria criteria : job.getCultureCriteriasSet())
            {
                CultureCriteria criteriaCopy = CultureCriteria.createCultureCriteria(newObjTran);

                criteriaCopy.setIsApplicable(criteria.getIsApplicable());
                criteriaCopy.setCultureElement(criteria.getCultureElement().getInTransaction(newObjTran));
                criteriaCopy.setImportance(criteria.getImportance());
                
                if(criteria.getCultureElementRating()!=null)
                {
                    criteriaCopy.setCultureElementRating(criteria.getCultureElementRating().getInTransaction(newObjTran));
                }
                
                newTemplate.addToCultureCriterias(criteriaCopy);
            }
        });
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "SaveCultureTemplateFP completed for ", job);
        
        job.setSaveCultureTemplate(Boolean.FALSE);
        job.setCultureTemplateName(null);
        
        NotificationUtils.setNotifyIDInRequest(request, messageId);
        
        return RedisplayResult.getInstance();
    }

    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute("Job");
        
        for(CultureCriteria criteria: job.getCultureCriteriasSet())
        {
            if(criteria.getIsApplicable())
            {
                BusinessObjectParser.assertFieldCondition(criteria.getCultureElementRating() != null, criteria , CultureCriteria.SINGLEREFERENCE_CultureElementRating, "mandatory", exceptions, true, request);
                BusinessObjectParser.assertFieldCondition(criteria.getImportance() != null, criteria , CultureCriteria.FIELD_Importance, "mandatory", exceptions, true, request);
            }
        }
        
        BusinessObjectParser.assertFieldCondition(job.getCultureTemplateName() != null, job , Job.FIELD_CultureTemplateName, "mandatory", exceptions, true, request);
        
        super.validate(process, submission, exceptions, params);
    }
}