import { CLASSES } from '../constants';
import { ApplicantSourcesEnum } from './applicant-sources.enum';
import { ApplicationStatusEnum } from './application-status.enum';
import { MessageModel } from './message.model';
import { WorkflowStageModel } from './workflow-stage.model';

export class JobApplicationModel {
    ObjectID: string;
    ObjectClass = CLASSES.JOB_APPLICATION;
    id: string;
    CV: string;
    CoverLetter: string;
    ApplicationStatus: ApplicationStatusEnum;
    SubmittedDate: string;
    GoogleAddressText: string;
    PreferRemote: boolean;
    HappyToRelocate: boolean;
    IsEmailIngest: boolean;
    ApplicantSource: ApplicantSourcesEnum;
    AppProcessOption: string;
    OverallRank: number;
    RoleFit: string;
    RequirementFit: string;
    CultureFit: string;
    FactorScoreDetails: string;
    Note: string;
    Candidate: string;
    Job: string;
    WorkFlowStage: WorkflowStageModel;
    AssessmentCriteriaAnswers: string;
    Notes: string;
    ScheduledEmails: string;
    SentEmails: string;
    Messages: Array<MessageModel>;
}
