<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="stdimports.jsp" %>
<%@ include file="/editor/stdimports.jsp" %>

<%! protected String getName (ServletConfig config) { return "changeCompanyPopup_jsp"; } %>
<%
    ORMProcessState     process     =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran     =   process.getTransaction ();
    HiringTeam          hiringTeam  =   (HiringTeam) process.getAttribute("HiringTeam");
    
    hiringTeam.setCompanyStatus(hiringTeam.getCompany().getCompanyStatus());
    
    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "changeCompanyPopup").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "Change Customer Popup");
%>

<%@include file="/editor/header.jsp" %>

<script type="text/javascript">
    $(document).ready(function(){
        setupRecalc ($("form"), {'recalcOnError':true});
    });
</script>

<oneit:layout_total widths="<%= new double[] {4, 8} %>" skin="bootstrap">

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1"><oneit:label GUIName="Hiring Team" /></oneit:layout_label>
        <oneit:layout_field width="1"><oneit:toString value="<%= hiringTeam.getHiringTeamName() %>" mode="EscapeHTML"/></oneit:layout_field>
    </oneit:skin>
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1"><oneit:label GUIName="Customer Status" /></oneit:layout_label>
        <oneit:layout_field width="1"><oneit:ormEnum obj="<%= hiringTeam %>"   attributeName="CompanyStatus"    cssClass="form-control"/></oneit:layout_field>
    </oneit:skin>
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="ExistingCustomer"   value="true"/> Existing Customer
        </oneit:layout_label>
    </oneit:skin>
    <oneit:skin tagName="layout_row">
        <oneit:recalcClass  htmlTag="span"  classScript="hiringTeam.isTrue(hiringTeam.getExistingCustomer()) ? 'show col-xs-offset-1' : 'hide'"    hiringTeam="<%= hiringTeam %>">
            <oneit:layout_label width="1"><oneit:label GUIName="Customer" /></oneit:layout_label>
            <oneit:layout_field width="1">
                <tagfile:ormsingleasso_autocomplete obj="<%= hiringTeam %>" assocName="Company"  cssClass="form-control" searcher="<%= CompanySearcher.INSTANCE %>" />
            </oneit:layout_field>
        </oneit:recalcClass>
    </oneit:skin>
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="ExistingCustomer"   value="false"/> New Customer
        </oneit:layout_label>
    </oneit:skin>
    <oneit:recalcClass  htmlTag="span"  classScript="hiringTeam.isFalse(hiringTeam.getExistingCustomer()) ? 'show col-xs-offset-1' : 'hide'"    hiringTeam="<%= hiringTeam %>">
        <oneit:skin tagName="layout_row">
                <oneit:layout_label width="1"><oneit:label GUIName="Customer Name" /></oneit:layout_label>
                <oneit:layout_field width="1">
                    <oneit:ormInput obj="<%= hiringTeam %>" type="text" attributeName="CompanyName" cssClass="form-control" />
                </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_label width="1"><oneit:label GUIName="Time Zone" /></oneit:layout_label>
            <oneit:layout_field width="1">
                <oneit:ormEnum  obj="<%= hiringTeam %>"    attributeName="CompanyTimeZone" cssClass="form-control"/>
            </oneit:layout_field>
        </oneit:skin>
        <oneit:skin tagName="layout_row">
            <oneit:layout_label width="1"><oneit:label GUIName="What type of hiring team are you?" /></oneit:layout_label>
        </oneit:skin>
        <%
            FormTag     jobForm     =   FormTag.getActiveFormTag(request);
            FormBuilder formBuilder =   jobForm.getFormBuilder();
            String      optionKey   =   WebUtils.getInputKey(request, hiringTeam, HiringTeam.FIELD_CompanyType);
            String      formValue   =   formBuilder.fieldValue (optionKey, hiringTeam.getCompanyType() == null ? "" : hiringTeam.getCompanyType().getName());

            for(HiringTeamType hiringTeamType : HiringTeamType.getHiringTeamTypeArray())
            {
                boolean isSelected          =   CollectionUtils.equals(formValue, hiringTeamType.getName());
                String  hiringTeamTypeId    =   String.valueOf(hiringTeam.getID().longID()) + "_hiringteamtype_" + hiringTeamType.getName();
                String  selected            =   isSelected ? "checked" : "";
                String  activeClass         =   isSelected ? "active" : "";
        %>
            <oneit:skin tagName="layout_row">
                <oneit:layout_field width="2">
                    <input  type="radio"    name="<%= optionKey %>"    id="<%= hiringTeamTypeId %>"    class="element_rating_radio" value="<%= hiringTeamType.getName() %>" <%= selected%>>
                    <label  for="<%= hiringTeamTypeId %>">
                        <oneit:toString value="<%= hiringTeamType %>"   mode="EscapeHTML"/>
                    </label>
                </oneit:layout_field>
            </oneit:skin>
        <%
            }
        %>        
    </oneit:recalcClass>

    <oneit:skin tagName="layout_row">
        <oneit:layout_field width="2">
            <oneit:button   value="Save"    cssClass="btn btn-primary pull-right"    name="changeCompany" 
                            requestAttribs="<%= CollectionUtils.mapEntry("HiringTeam", hiringTeam)
                                                                .toMap() %>"/>
        </oneit:layout_field>
    </oneit:skin>
    
</oneit:layout_total>

<%@include file="/editor/footer.jsp" %>