package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.DiversityQuestion;
import performa.orm.HTDiversityQuestion;
import performa.orm.HiringTeam;
import performa.orm.types.Countries;


public class ChangeDiversityFP  extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction   objTran     =   process.getTransaction();
        HiringTeam          hiringTeam  =   (HiringTeam) request.getAttribute("HiringTeam");

        LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "Inside ChangeDiversityFP for ", hiringTeam , " Has Diversity:", hiringTeam.getHasDiversity());
        
        if(hiringTeam.showHasDiversity())
        {
            if(hiringTeam.getDiversityQuestionsCount() == 0)
            {
                for(DiversityQuestion question  : DiversityQuestion.searchAll(objTran))
                {
                    if(hiringTeam.getCountry() != Countries.AU && question.getAustraliaOnly())
                    {
                        continue;
                    }
                    
                    HTDiversityQuestion htDiversityQuestion =   HTDiversityQuestion.createHTDiversityQuestion(objTran);

                    htDiversityQuestion.setQuestion(question);
                    htDiversityQuestion.setQuestionText(question.getQuestionText());
                    htDiversityQuestion.setHiringTeam(hiringTeam);
                    
                    LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "ChangeDiversityFP created diversity question : ",  htDiversityQuestion);
                }
            }
        }
        
        LogMgr.log(HiringTeam.LOG, LogLevel.PROCESSING1, "ChangeDiversityFP completed for ",  hiringTeam);
        
        return RedisplayResult.getInstance();
    }
}
