<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ page import="oneit.utils.filter.*"%>
<oneit:dynIncluded>
<%
    ObjectTransaction       objTran         =   process.getTransaction ();
    String                  nextPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String                  shortlistPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.APPLICANTS_SHORTLIST);
    String                  homePage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    JobStatus               jobStatus       =   null;
    JobSortOption           jobSortOpt      =   null;
    Client                  selectedClient  =   null;
    SecUser                 txUser          =   SecUser.getTXUser(objTran);
    CompanyUser             companyUser     =   txUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam              hiringTeam      =   companyUser.getSelectedTeam();
    Map<String, String[]>   parameterMap    =   request.getParameterMap();

    // handle job sort option
    if( request.getParameter("JobSortOption") != null)
    {
        jobSortOpt  =   JobSortOption.forName((String) request.getParameter("JobSortOption"));
    }
    else if(process.getAttribute("JobSortOption") != null)
    {
        jobSortOpt  =   (JobSortOption) process.getAttribute("JobSortOption");
    }
    else
    {
        jobSortOpt  =   (JobSortOption) session.getAttribute("JobSortOption");
    }
    
    if(jobSortOpt == null)
    {
        jobSortOpt  =   JobSortOption.NEWEST;
    }

    session.setAttribute("JobSortOption", jobSortOpt);

    // handle job status
    if( parameterMap.containsKey("JobStatus"))
    {
        if(!request.getParameter("JobStatus").isEmpty())
        {
            jobStatus  =   JobStatus.forName((String) request.getParameter("JobStatus"));
        }
    }
    else if(process.getAttribute("JobStatus") != null)
    {
        jobStatus  =   (JobStatus) process.getAttribute("JobStatus");
    }
    else
    {
        jobStatus  =   (JobStatus) session.getAttribute("JobStatus");
    }
    
    session.setAttribute("JobStatus", jobStatus);

    // handle client
    if( parameterMap.containsKey("Client"))
    {
        if(!request.getParameter("Client").isEmpty())
        {
            selectedClient  =   Client.getClientByID(objTran, Long.valueOf(request.getParameter("Client")));
        }
    }
    else
    {
        selectedClient  =   (Client) session.getAttribute("Client");
    }
    
    session.setAttribute("Client", selectedClient);
    
    String              jobListName =   "Job" + hiringTeam.getID() +jobStatus;
    Job[]               jobs        =   (Job[]) process.getAttribute(jobListName);
    
    if(jobs == null)
    {
        jobs    =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(jobStatus))
                                    .andHiringTeam(new EqualsFilter<>(hiringTeam))
                                    .search(transaction);
        
        process.setAttribute(jobListName, jobs);
    }

    List<Job>   jobList =   Arrays.asList(jobs);

    if(selectedClient != null)
    {
        oneit.utils.filter.Filter<Job>  filter  =   Job.SearchByAll().andClient(new EqualsFilter<>(selectedClient));

        jobList =   new ArrayList<>(CollectionFilter.filter(jobList, filter));
    }

    List<Job>   sortedJobs  =   Utils.getJobsSorted(jobList, jobSortOpt, jobStatus);
    
    process.setAttribute("JobSortOption", jobSortOpt);
    process.setAttribute("JobStatus", jobStatus);
%>
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area second-part">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <div class="jobs-list-shorting">
                <div class="d-job-title all-jobs-title">
                    <%= jobStatus == null ? "All" : jobStatus.getDescription() %> Jobs
                </div>
                <%
                    if(jobs.length > 1)
                    {
                %>
                        <div class="shorting-dropdown">
                            <div class="order-label">order by</div>
                            <select class="form-control"    onChange="location=this.value">
                                <%
                                    for (JobSortOption  sortOption : JobSortOption.getJobSortOptionArray())
                                    {
                                        String  optionLink  =    homePage + "&JobSortOption=" + sortOption.getName() ;
                                %>
                                        <option <%= (jobSortOpt != null && jobSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                            <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                        </option>
                                <%
                                    }
                                %>
                            </select>
                        </div>
                <%
                    }
                %>
                <div class="shorting-dropdown">
                    <div class="order-label">showing</div>
                    <select class="form-control"    onChange="location=this.value">
                        <option <%= (jobStatus == null ? "selected" : "" )%>  value="<%= homePage + "&JobStatus" %>">
                            <oneit:toString value="All Jobs"   mode="EscapeHTML"/>
                        </option>
                        <%
                            for (JobStatus  sortOption : Utils.getJobStatusesForClient())
                            {
                                String  optionLink  =    homePage + "&JobStatus=" + sortOption.getName() ;
                        %>
                                <option <%= (jobStatus != null && jobStatus == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                    </select>
                </div>
                <div class="shorting-dropdown">
                    <div class="order-label">client</div>
                    <select class="form-control"    onChange="location=this.value">
                        <option <%= (selectedClient == null ? "selected" : "" )%>  value="<%= homePage + "&Client"%>">
                            <oneit:toString value="All Clients"   mode="EscapeHTML"/>
                        </option>
                        <%
                            for (Client  client : Utils.getClientsByHiringTeam(objTran))
                            {
                                String  optionLink  =    homePage + "&Client=" + client.getID().longID() ;
                        %>
                                <option <%= (client != null && selectedClient != null && client.equals(selectedClient) ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= client.getClientName() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                    </select>
                </div>
                
            </div>
                    
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_list.jsp" data="<%= CollectionUtils.EMPTY_MAP%>"  ShortlistPage="<%= shortlistPage %>"
                                NextPage="<%= nextPage%>"   HomePage="<%= homePage%>"   Jobs="<%= sortedJobs.toArray(new Job[0]) %>"    JobStatus="<%= jobStatus %>"
                                JobSortOption="<%= jobSortOpt %>" />
            
        </div>
    </oneit:form>
</oneit:dynIncluded>
