package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.utils.NotificationUtils;
import oneit.utils.*;
import performa.orm.CultureCriteria;
import performa.orm.CultureCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class SaveCultureTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "Inside SaveCultureTemplateFP for create new template for ", job);
        
        String messageId = NotificationUtils.getNotifyIdIfRequired(process, request);
        
        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            CultureCriteriaTemplate newTemplate =   CultureCriteriaTemplate.createCultureCriteriaTemplate(newObjTran);
            
            newTemplate.setUser(SecUser.getTXUser(newObjTran));
            newTemplate.setTemplateName(job.getCultureTemplateName());
            
            for(CultureCriteria criteria : job.getCultureCriteriasSet())
            {
                CultureCriteria criteriaCopy = CultureCriteria.createCultureCriteria(newObjTran);

                criteriaCopy.setCultureElement(criteria.getCultureElement().getInTransaction(newObjTran));
                criteriaCopy.setImportance(criteria.getImportance());
                criteriaCopy.setCultureElementRating(criteria.getCultureElementRating().getInTransaction(newObjTran));

                newTemplate.addToCultureCriterias(criteriaCopy);
            }
        });
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1, "SaveCultureTemplateFP completed for ", job);
        
        NotificationUtils.setNotifyIDInRequest(request, messageId);
        
        return RedisplayResult.getInstance();
    }

    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   (Job) request.getAttribute("Job");
        
        BusinessObjectParser.assertFieldCondition(job.getCultureTemplateName() != null, job , Job.FIELD_CultureTemplateName, "mandatory", exceptions, true, request);

        super.validate(process, submission, exceptions, params);
    }
}