package performa.form;

import javax.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.DateDiff;
import oneit.utils.MultiException;
import performa.intercom.utils.IntercomUtils;
import performa.orm.CompanyUser;
import performa.orm.Job;
import performa.orm.types.JobStatus;


public class SaveJobFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   process.getAttribute("Job") != null ? (Job) process.getAttribute("Job") : (Job) request.getAttribute("Job");
        Boolean             openJob =   (Boolean) request.getAttribute("openJob");
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In SaveJobFP saving job : ", job );

        Job oldJob  = (Job) job.getEarliestBackup();

        if(openJob==Boolean.TRUE)
        {
            job.setJobStatus(JobStatus.OPEN);
            
            LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"Job status changed as Open. ", job );
        }
        
        if(oldJob != null && oldJob.getJobStatus() == JobStatus.DRAFT && job.getJobStatus() == JobStatus.OPEN)
        {
            job.setApplyBy(DateDiff.add(DateDiff.getToday(), Calendar.DATE, 30));
            job.setOpenDate(new Date());
        }
        
        if(job.getJobStatus() == JobStatus.OPEN && job.getShortenedURL() == null)
        {
            job.createShortenedURL();
        }
        
        if(job.getJobStatus() == JobStatus.COMPLETE)
        {
            job.setIsManuallyClosed(Boolean.TRUE);
        }
        
        // restarting process as custom attributes needs to be updated to intercom
        completeProcessRestartAndRestoreAttribs(process, request);
        
        SecUser     secUser     =   SecUser.getTXUser(process.getTransaction());
        CompanyUser companyUser =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);

        // Update company in intercom
        if(companyUser.getCompany() != null)
        {
            IntercomUtils.updateCompany(companyUser.getCompany());
        }
        
        return super.processForm(process, submission, params);
    }
    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        Job                 job     =   process.getAttribute("Job") != null ? (Job) process.getAttribute("Job") : (Job) request.getAttribute("Job");
        Boolean             openJob =   (Boolean) request.getAttribute("openJob");

        if(job.getJobStatus() != JobStatus.DRAFT || openJob == Boolean.TRUE)
        {
            BusinessObjectParser.assertFieldCondition(job.getLevel() != null, job , Job.SINGLEREFERENCE_Level, "mandatory", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}