<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ page import="oneit.utils.filter.CollectionFilter"%>


<oneit:dynIncluded>
<%
    String              currentPage     =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.MANAGE_USERS).getLink(request);
    String              usersPage       =   WebUtils.getSamePageInRenderMode(request, "Page");
    ObjectTransaction   objTran         =   process.getTransaction ();
    SecUser             secUser         =   SecUser.getTXUser(objTran);
    Company             company         =   (Company) process.getAttribute("Company");
    CompanyUser         comUser         =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam          hiringTeam      =   comUser.getActiveHiringTeam();
    UserSortOption      userSortOpt     =   (UserSortOption) process.getAttribute("UserSortOption");
    Set<CompanyUser>    allUsers        =   CompanyUserHiringTeamLink.pipesCompanyUserHiringTeamLink(hiringTeam.getUsersSet()).toCompanyUser().uniqueVals();
    Collection          companyUsers    =   CollectionFilter.filter(allUsers, CompanyUser.SearchByAll().andIsAccountVerified(new EqualsFilter<>(Boolean.TRUE)).andIsDisabled(new EqualsFilter<>(Boolean.FALSE)));
    Collection          pendingUsers    =   CollectionFilter.filter(allUsers, CompanyUser.SearchByAll().andIsAccountVerified(new NotEqualsFilter<>(Boolean.TRUE)));
    Collection          disabledUsers   =   CollectionFilter.filter(allUsers, CompanyUser.SearchByAll().andIsAccountVerified(new EqualsFilter<>(Boolean.TRUE)).andIsDisabled(new EqualsFilter<>(Boolean.TRUE)));
    InviteTeammateNPO   inviteTeammate  =   (InviteTeammateNPO) process.getAttribute("InviteTeammate");

    Debug.assertion(hiringTeam != null, "Hiring Team is null in admin portal Manage Teammates");

    if(inviteTeammate == null)
    {
        inviteTeammate  =   InviteTeammateNPO.createInviteTeammateNPO(objTran);
        
        inviteTeammate.addToHiringTeams(HiringTeamLinkNPO.createHiringTeamLinkNPO(objTran));
        process.setAttribute("InviteTeammate", inviteTeammate);
    }

    if(company == null)
    {
        company =   comUser.getCompany();
        process.setAttribute("Company", company);
    }
    
    if( request.getParameter("UserSortOption") != null)
    {
        userSortOpt =   UserSortOption.forName((String) request.getParameter("UserSortOption"));
    }
    
    if(userSortOpt == null)
    {
        userSortOpt =   UserSortOption.ALPHA_A_Z;
    }
    
    process.setAttribute("UserSortOption", userSortOpt);
    
    Collection<CompanyUser> sortedCompanyUsers  =   Utils.getUsersSorted(companyUsers, userSortOpt);
    Collection<CompanyUser> sortedPendingUsers  =   Utils.getUsersSorted(pendingUsers, userSortOpt);
    Collection<CompanyUser> sortedDisabledUsers =   Utils.getUsersSorted(disabledUsers, userSortOpt);

    inviteTeammate.setRoleType(RoleType.STANDARD);
%>
    <script type="text/javascript">
       
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form#listUsers"), {'recalcOnError':true});

            $(".user-role").change(function()
            {
                var id  = $(this).closest('.user-list-row').attr('id');
                $('.save-user' + id).click();
            });
            
            validate();
            
            addPostRecalcHandler(function   ($fieldThatChanged)
            {   
                if (! $fieldThatChanged)
                {
                    return;
                }
                var name        = $fieldThatChanged.attr('name');
                
                if (typeof name !== typeof undefined && name !== false)
                {
                    if ( name.indexOf('UserEmail') >= 0 )
                    {
                        validate();
                        recalcFunction();
                    }
                }
            });
            $('input[name$=UserEmail]').on("keyup", function() {
                recalcFunction();
                validate();
            });
        });
        
        function validate() {
            if ($('.invite-btn').hasClass('disabled')) {
                $('.btn-invite').attr('disabled', 'disabled');
            } else {
                $('.btn-invite').removeAttr('disabled');
            }
        }
    </script>
    <style>
        button[disabled]{
            opacity: 0.6;
            background-color: #0582ba;
        }
    </style>
    <oneit:form name="listUsers" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area second-part">
                        
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="eq-justify-content">
                <div class="manage-user-left">
                    <div class="jobs-list-shorting">
                        <div class="d-job-title all-jobs-title">Teammates <span class="teammate-hiringteam">(<%= hiringTeam %>)</span></div>
                        <div class="shorting-dropdown">
                            <span class="order-label">order by</span>
                            <select class="form-control"    onChange="location=this.value">
                            <%
                                for (UserSortOption  sortOption : UserSortOption.getUserSortOptionArray())
                                {
                                    String  optionLink  =    usersPage + "&UserSortOption=" + sortOption.getName() ;
                            %>
                                    <option <%= (userSortOpt != null && userSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                        <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                    </option>
                            <%
                                }
                            %>
                            </select>
                        </div>
                    </div>
                    <div class="main-manage-userlist">
                        
                        
                    <%
                        for(CompanyUser companyUser : sortedCompanyUsers)
                        {
                            SecUser user    =   companyUser.getUser();
                    %>
                            <div class="user-list-row"  id="<%= companyUser.getID() %>">
                                <div class="m-user-left">
                                    <oneit:recalcClass  htmlTag="div"   classScript="companyUser.isOwner(hiringTeam) ? 'hide': 'show'"  companyUser="<%= companyUser %>"    hiringTeam="<%= hiringTeam %>">
                                        <oneit:button   value=" "    name="saveCompanyUser" skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                    .mapEntry("remove", Boolean.TRUE)
                                                                                    .mapEntry("CompanyUser", companyUser)
                                                                                    .mapEntry("HiringTeam", hiringTeam)
                                                                                    .toMap() %>">
                                            <div class="remove-icon">_</div>
                                        </oneit:button>
                                    </oneit:recalcClass>
                                    <div class="m-user-icon"><img src="images/user-list-icon.png"></div>
                                    <div class="m-user-info">
                                        <div class="m-user-name">
                                            <oneit:toString value="<%= SecUserToNameTransform.INSTANCE.transform(user) %>"  mode="EscapeHTML" />
                                            <%
                                                if(companyUser.isOwner(hiringTeam))
                                                {
                                            %>
                                                    <span class="m-user-email">owner</span>
                                            <%
                                                }
                                            %>
                                        </div>
                                        <div class="m-user-email">
                                            <oneit:toString value="<%= user.getEmail() %>"  mode="EscapeHTML" />
                                        </div>
                                    </div>
                                </div>
                                
                                    <div class="m-user-right-padlock">
                                        <oneit:recalcClass  htmlTag="div"   classScript="companyUser.isOwner(hiringTeam) || companyUser == comUser ? 'hide': 'show'"  companyUser="<%= companyUser %>"    hiringTeam="<%= hiringTeam %>"    comUser="<%= comUser %>">
                                            <div class="arrow_box disble" >DISABLE</div>
                                            <div class="arrow_box enable" >ENABLE</div>
                                            <oneit:button   value=" "    name="saveCompanyUser" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                        .mapEntry("disabled", Boolean.TRUE)
                                                                                        .mapEntry("CompanyUser", companyUser)
                                                                                        .toMap() %>">
                                                <span class="m-user-right-padlockicon"><span class="padlock"></span></span>
                                            </oneit:button>
                                        </oneit:recalcClass>
                                    </div>
                                
                                <div class="m-user-right">
                                    <oneit:ormEnum  obj="<%= companyUser %>"    attributeName="Role"    cssClass="form-control user-role"   enums="<%= Arrays.asList(new RoleType[]{RoleType.ADMIN, RoleType.STANDARD}) %>"/>
                                </div>
                                
                                <oneit:button   name="save"  value="Save"    cssClass="<%= "save-user" +  companyUser.getID().toString() + " hidden"%>"
                                                requestAttribs="<%= CollectionUtils.mapEntry("CompanyUser", companyUser).mapEntry("nextPage", usersPage + "&UserSortOption=" + userSortOpt).toMap() %>" />
                            </div>
                    <%
                        }
                    %>
<!--                
                        No button provided to edit a record, hence hiding this section
                        <div class="user-list-row">
                            <div class="m-save-user">
                                <input type="text" placeholder="First Name" class="form-control" />
                                <input type="text" placeholder="Surname" class="form-control" />
                                <input type="text" placeholder="Email" class="form-control" />
                            </div>
                            <div class="save-button">
                                <input type="button" class="btn btn-save" value="save">
                            </div>
                        </div>
-->

                <div class="seperator-dots"><span class="dot"></span><span class="dot"></span><span class="dot"></span></div>
                    <%
                        for(CompanyUser pendingUser : sortedPendingUsers)
                        {
                            SecUser user        =   pendingUser.getUser();
                            String  name        =   StringUtils.subBlanks(user.getName())!=null ? user.getName() : user.getUserName();
                            String  resendTxt   =   "Re-send invitation to " + (StringUtils.subBlanks(user.getFirstName())!=null ? user.getFirstName() : StringUtils.subBlanks(user.getLastName())!=null ? user.getLastName() : user.getUserName());
                    %>
                            <div class="user-list-row invite-row" id="<%= pendingUser.getID() %>">
                                <div class="m-user-left">
                                    <div class="m-user-icon"><img src="images/user-list-icon.png"></div>
                                    <div class="m-user-info">
                                        <div class="m-user-name">
                                            <oneit:toString value="<%= name %>"  mode="EscapeHTML" />
                                        </div>
                                        <div class="m-user-email">
                                            <oneit:toString value="<%= user.getEmail() %>"  mode="EscapeHTML" />
                                        </div>
                                    </div>
                                </div>
                                       
                                <div class="m-user-right invite-combo">
                                    <select class="form-control" disabled="">
                                        <option>Invitation sent</option>
                                    </select>
                                </div>
                               
                            </div>
                            <div class="resend-link">
                                <oneit:button   value="<%= resendTxt %>"    name="sendUserInvites"  skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                .mapEntry ("ResendUser", pendingUser)
                                                                                .mapEntry ("HiringTeam", hiringTeam)
                                                                                .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "invitationSent")
                                                                                .toMap() %>" />
                            </div>
                    <%
                        }
                        
                        for(CompanyUser companyUser : sortedDisabledUsers)
                        {
                            SecUser user    =   companyUser.getUser();
                    %>
                            <div class="user-list-row disabled"  id="<%= companyUser.getID() %>">
                                <div class="m-user-left">
                                    <div class="remove-icon">_</div>
                                    <div class="m-user-icon"><img src="images/user-list-icon.png"></div>
                                    <div class="m-user-info">
                                        <div class="m-user-name">
                                            <oneit:toString value="<%= SecUserToNameTransform.INSTANCE.transform(user) %>"  mode="EscapeHTML" />
                                        </div>
                                        <div class="m-user-email">
                                            <oneit:toString value="<%= user.getEmail() %>"  mode="EscapeHTML" />
                                        </div>
                                    </div>
                                </div>
                                <div class="m-user-right-padlock">
                                    <div class="arrow_box disble" >DISABLE</div>
                                    <div class="arrow_box enable" >ENABLE</div>
                                    <oneit:button   value=" "    name="saveCompanyUser" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                                .mapEntry("disabled", Boolean.FALSE)
                                                                                .mapEntry("CompanyUser", companyUser)
                                                                                .toMap() %>">
                                        <span class="m-user-right-padlockicon"><span class="padlock"></span></span>
                                    </oneit:button>
                                </div>
                                <div class="m-user-right">
                                    <oneit:ormEnum  obj="<%= companyUser %>"    attributeName="Role"    cssClass="form-control user-role"   enums="<%= Arrays.asList(new RoleType[]{RoleType.ADMIN, RoleType.STANDARD}) %>"/>
                                </div>
                               
                                
                                <oneit:button   name="save"  value="Save"    cssClass="<%= "save-user" +  companyUser.getID().toString() + " hidden"%>"
                                                requestAttribs="<%= CollectionUtils.mapEntry("CompanyUser", companyUser).mapEntry("nextPage", usersPage + "&UserSortOption=" + userSortOpt).toMap() %>" />
                            </div>
                    <%
                        }
                    %>
                    </div>
                </div>
                <div class="manage-user-right">
                    <div class="sidebar-title">
                        Invite a teammate
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Email Address" /></label>
                        <oneit:ormInput obj="<%= inviteTeammate %>"    type="text" attributeName="UserEmail"   cssClass="form-control" style="text-transform: lowercase"/>
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="First Name" /></label>
                        <oneit:ormInput obj="<%= inviteTeammate %>"    type="text" attributeName="FirstName"   cssClass="form-control"/>
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Last Name" /></label>
                        <oneit:ormInput obj="<%= inviteTeammate %>"    type="text" attributeName="LastName"   cssClass="form-control"/>
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Role" /></label>
                        <oneit:ormEnum  obj="<%= inviteTeammate %>"    attributeName="RoleType"    cssClass="form-control"/>
                    </div>
                    <div class="form-group">
                        <label><oneit:label GUIName="Add to multiple Hiring Teams" /></label>
                    </div>
                    <%
                        for(HiringTeamLinkNPO inviteTeammateLink : inviteTeammate.getHiringTeamsSet())
                        {
                    %>
                        <div class="form-group">
                            <div class="wider-select">
                                <tagfile:ormsingleasso_select obj="<%= inviteTeammateLink %>"     assocName="HiringTeam"  options="<%= Utils.getOtherHiringTeams(hiringTeam) %>"/>
                            </div>
                        </div>
                    <%
                        }
                    %>
                    <oneit:button   value=" "   name="additionalTeam" skin="link"   requestAttribs="<%= CollectionUtils.EMPTY_MAP %>">
                        <label><oneit:label GUIName="Add another hiring team" /></label>
                    </oneit:button>
                    <div  class="correctEmail" >
                        <oneit:recalc mode="Boolean" script="company.isEmailCorrect()" company="<%= company %>" />
                    </div>
                    <oneit:recalcClass  htmlTag="div"   classScript="inviteTeammate.isEmailCorrect() ? 'invite-btn enabled': 'invite-btn disabled'"  inviteTeammate="<%= inviteTeammate %>">
                        <oneit:button   value="Invite"  name="sendUserInvites"  cssClass="btn btn-invite"   
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", currentPage)
                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                        .mapEntry ("HiringTeam", hiringTeam)
                                                                        .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "invitationSent")
                                                                        .toMap() %>" />
                    </oneit:recalcClass>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>
