
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import oneit.security.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class AssessmentCriteriaTemplatePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea AssessmentCriteriaTemplatePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "AssessmentCriteriaTemplate");

    // Private attributes corresponding to business object data
    private String dummyTemplateName;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_TemplateName = DefaultAttributeHelper.INSTANCE;
    



    public AssessmentCriteriaTemplatePersistenceMgr ()
    {
        dummyTemplateName = (String)(HELPER_TemplateName.initialise (dummyTemplateName));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_assessment_template.object_id as id, {PREFIX}tl_assessment_template.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_assessment_template.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_assessment_template.template_name, {PREFIX}tl_assessment_template.user_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, AssessmentCriteriaTemplate.REFERENCE_AssessmentCriteriaTemplate);

                if (objectToReturn instanceof AssessmentCriteriaTemplate)
                {
                    LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a AssessmentCriteriaTemplate");
                }
            }

            PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(id, "tl_assessment_template", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_assessment_templatePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_assessment_templatePSet.containsAttrib(AssessmentCriteriaTemplate.FIELD_TemplateName)||
                    !tl_assessment_templatePSet.containsAttrib(AssessmentCriteriaTemplate.SINGLEREFERENCE_User))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                AssessmentCriteriaTemplate result = new AssessmentCriteriaTemplate ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_assessment_template " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_assessment_template.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(objectID, "tl_assessment_template");
            

            
            if (tl_assessment_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_assessment_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_assessment_template " +
                                                           "SET template_name = ?, user_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_assessment_template.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_assessment_templatePSet.getAttrib (AssessmentCriteriaTemplate.FIELD_TemplateName))).listEntry (SQLManager.CheckNull((Long)(tl_assessment_templatePSet.getAttrib (AssessmentCriteriaTemplate.SINGLEREFERENCE_User)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_assessment_template WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_assessment_template", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_assessment_template");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_assessment_template for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_assessment_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(objectID, "tl_assessment_template");
        

        LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_assessment_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_assessment_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_assessment_template " +
                                                       "WHERE tl_assessment_template.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_assessment_template WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_assessment_template");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_assessment_template for row:" + objectID;

                    LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_assessment_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryCompany (SQLManager sqlMgr, Company Company) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryCompany");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, AssessmentCriteriaTemplate> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (AssessmentCriteriaTemplate.REFERENCE_AssessmentCriteriaTemplate.getObjectIDSpace (), r.getLong ("id"));
            AssessmentCriteriaTemplate resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, AssessmentCriteriaTemplate.REFERENCE_AssessmentCriteriaTemplate);

                if (cachedElement instanceof AssessmentCriteriaTemplate)
                {
                    LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (AssessmentCriteriaTemplate)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a AssessmentCriteriaTemplate");
                }
            }
            else
            {
                PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(objectID, "tl_assessment_template", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new AssessmentCriteriaTemplate ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (AssessmentCriteriaTemplatePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_assessment_template " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (AssessmentCriteriaTemplate.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_assessment_template.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_assessment_template.object_id is not null
                    String preFilter = "(tl_assessment_template.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_assessment_template " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (AssessmentCriteriaTemplate.SEARCH_Company))
        {
            // Local scope for transformed variables
            {
                
                if (criteria.containsKey("Company"))
                {
                Company Company = (Company)(criteria.get("Company"));
                criteria.put ("Company", Company.getObjectID ());
                }
            }


            
                String      orderBy = " ORDER BY tl_assessment_template.object_id";
                String      tables = ", oneit_sec_user_extension, tl_company ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_assessment_template.object_id is not null
                    String preFilter = "(tl_assessment_template.object_id is not null)"
                                     + " AND (oneit_sec_user_extension.user_id = tl_assessment_template.user_id) AND (tl_company.object_id = oneit_sec_user_extension.company_id)  ";
                    
                        if (criteria.containsKey("Company"))
                        {
                            preFilter += " AND (tl_company.object_id = ${Company}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_assessment_template " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(objectID, "tl_assessment_template", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_assessment_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_assessment_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_assessment_templatePSet.setAttrib(AssessmentCriteriaTemplate.FIELD_TemplateName, HELPER_TemplateName.getFromRS(dummyTemplateName, r, "template_name"));
        
        tl_assessment_templatePSet.setAttrib(AssessmentCriteriaTemplate.SINGLEREFERENCE_User, r.getObject ("user_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_assessment_templatePSet = allPSets.getPersistentSet(objectID, "tl_assessment_template");
        

        
        if (tl_assessment_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_assessment_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_assessment_template " +
                                     "  (template_name,  user_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_assessment_templatePSet.getAttrib (AssessmentCriteriaTemplate.FIELD_TemplateName))) .listEntry (SQLManager.CheckNull((Long)(tl_assessment_templatePSet.getAttrib (AssessmentCriteriaTemplate.SINGLEREFERENCE_User)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_assessment_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
