<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*, oneit.utils.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState         process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran         =   process.getTransaction();
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "Applications");

%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>


        </div>
        <div class="white-header">
            All Applicants
            <span><%= applications.size() %> Applicants</span>
        </div>
    
    <%
        for (JobApplication jobApplication : applications)
        {
            String  roleFit     =   FormatUtils.stringify(jobApplication.getRoleFitPercentage(), "PercentageWholeNumber", "0");
            String  culture     =   FormatUtils.stringify(jobApplication.getCultureFitScore(), "PercentageWholeNumber", "0");
    %>
        <div class="appli-row">        
            <div class="appli-list-name"> 
                <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                <div class="appli-status">
                    <oneit:toString value="<%= jobApplication.getApplicantStatusStr() %>"   mode="EscapeHTML" />
                </div>
            </div>
            <div class="appli-overall">
                Overall rank
                <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
            </div>
            
            <div class="appli-l eq-second-height">
                <span class="appli-view-bar">
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= roleFit %>" aria-valuemin="0" aria-valuemax="100" 
                                style="<%= "width: " + roleFit %>">
                            <span class="show-precentage"><%= roleFit %></span>
                        </div>
                    </div>
                </span>
                role fit
            </div>
                        
            <div class="appli-l eq-second-height">
                <span class="appli-view-bar">
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                style="<%= "width: " + culture %>">
                            <span class="show-precentage"><%= culture %></span>
                        </div>                                
                    </div>
                </span>
                culture fit
            </div>
            <%
                if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                {
                    long    criteriaVal =   jobApplication.getRequirementFitScore();
                    String  criteria    =   FormatUtils.stringify(criteriaVal, "PercentageWholeNumber", "0");
                    boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
            %>
                    <div class="appli-l eq-second-height">
                        <span class="appli-view-bar">
                            <div class="progress">
                                <div class="progress-bar <%= (criteriaVal == 100 && !missingReq ? " green" : "")%>" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                        style="<%= "width: " + criteria %>">
                                    <span class="show-precentage"><%= criteria %></span>
                                </div>
                            </div>
                                <span class="missing-requirements-icon" style="<%= missingReq ? "display:inline-block" : "display:none" %>"></span>
                        </span>
                        <span class="<%= missingReq ? "red-requirements" : "" %>">
                            requirements
                        </span>
                    </div>
            <%
                }
            %>           
                        
        </div>
    <%
        }
    %>
    </div>
</oneit:dynIncluded>