// @CodeReview : A008 : imports to be in proper order (already informed to use typehero plugin, which do the same), do this on all pages in system

import { Component, OnInit } from '@angular/core';
import * as FileSaver from 'file-saver';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { BaseComponent } from '../../base/base.component';
import { SummaryReportModel } from '../../models/summary-report.model';
import { AssessmentService } from '../../services/assessment.service';
import { HelperService } from '../../services/helper.service';

@Component({
    selector: 'app-summary-report',
    templateUrl: './summary-report.component.html',
    styleUrls: ['./summary-report.component.scss']
})
export class SummaryReportComponent extends BaseComponent implements OnInit {

    showBody = false;
    // @CodeReview :  : Try to manage 'colorClasses' in html / scss (as style in "ts" is not good way), 
    //                  but considering compleity of this report, leave it if can't be. 

    colorClasses = {
        'percent-yellow-b': {incompleteColor: '#e5e8eb', completeColor: '#fedd6f'}
    };
    reports: { report: SummaryReportModel, title: string, bgColor: string, bgImg: string }[] = [
        {report: null, title: 'ROLE FIT', bgImg: '', bgColor: this.colorClasses['percent-yellow-b'].incompleteColor},
        {report: null, title: 'CULTURE FIT', bgImg: '', bgColor: this.colorClasses['percent-yellow-b'].incompleteColor},
    ];
    selectedReport: { report: SummaryReportModel, title: string };
    ceil = Math.ceil;

    constructor(
        private assessmentService: AssessmentService,
        private helperService: HelperService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.isLoading = true;
        this.assessmentService.getSummaryReport(['Dots', 'Bars.SubBars'])
            .pipe(takeUntil(this.componentInView))
            .subscribe((response: SummaryReportModel[]) => {
                this.isLoading = false;
                response.forEach((r, i) => {
                    this.reports[i].report = r;
                    this.reports[i].bgImg = this.helperService.circleGradient(r.PercentageValue, this.colorClasses[r.ColorClass].completeColor, this.colorClasses[r.ColorClass].incompleteColor).backgroundImage;
                    this.reports[i].bgColor = this.colorClasses[r.ColorClass].completeColor;
                    r.Bars.forEach(b => {
                        b.SubBars.forEach(sb => {
                            sb.ParsedResults = [];
                            Object.keys(sb.Results).forEach(k => {

                                sb.ParsedResults.push({class: Object.keys(sb.Results[k])[0], value: sb.Results[k][Object.keys(sb.Results[k])[0]]});
                            });
                        })
                    });
                });
                this.selectedReport = this.reports[0];
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            });
    }

    downloadSummaryReport() {
        this.isLoading = true;

        this.assessmentService.downloadSummaryReport()
            .pipe(takeUntil(this.componentInView))
            .subscribe((response) => {
                this.isLoading = false;
                FileSaver.saveAs(response.content, 'Summary Report.pdf');
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            });
    }
}
