import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class AssessmentService {

  constructor(
      private utilsService: UtilsService,
      private searchService: SearchService
  ) { }

  getWorkStyle(assocs = [], previousQuestion): Observable<any> {
      const queryParams = previousQuestion ? {IsBack: true} : '';
      return this.searchService.getObjects('WorkStyle', 'All', queryParams, assocs, null, null, null, null)
          .map(
              data => {
                  return this.utilsService.convertResponseToObjects(data, assocs);
              }
          )
  }

  getWorkPreferences(assocs = [], previousQuestion = false): Observable<any> {
      const queryParams = previousQuestion ? {IsBack: true} : '';
      return this.searchService.getObjects('WorkPreferences', 'All', queryParams, assocs, null, null, null, null)
          .map(
              data => {
                  return this.utilsService.convertResponseToObjects(data, assocs);
              }
          )
  }

    getDiversityProfile(assocs = []): Observable<any> {
        return this.searchService.getObjects('DiversityProfile', 'All', '', assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

    getSummaryReport(assocs = []): Observable<any> {
        return this.searchService.getObjects('SummaryReport', 'All', '', assocs, null, null, null, null)
            .map(
                data => {
                    return this.utilsService.convertResponseToObjects(data, assocs);
                }
            )
    }

    downloadSummaryReport(): Observable<any> {
        return this.searchService.getObjectsWithDocument('SummaryReport', 'All', {}, [], null, null, null, null, 'SummaryReportPDF', false)
            .map(
                data => {
                    if (data !== undefined && data !== '') {
                        return data;
                    }
                }
            );
    }

    saveWorkStyle(params): Observable<any> {
        return this.utilsService.processObjects('SaveWorkStyle', params);
    }

    saveWorkPreferences(params): Observable<any> {
        return this.utilsService.processObjects('SaveWorkPreferences', params);
    }

    saveDiversityProfile(params): Observable<any> {
        return this.utilsService.processObjects('SaveDiversityProfile', params);
    }


}
