import { CLASSES } from '../config/constants';
import { BaseModel } from './base.model';
import { CandidateModel } from './candidate.model';
import { CareerSkillModel } from './career-skill.model';
import { EducationModel } from './education.model';
import { RefereeModel } from './referee.model';
import { WorkExperienceModel } from './work-experience.model';

export class CareerProfileModel extends BaseModel {
    ObjectClass = CLASSES.CAREER_PROFILE;
    Mobile: string;
    GoogleAddress: string;
    Skype: string;
    Candidate = new CandidateModel();
    CompletedPercentage: number;
    CompletedPercentageCH: number;
    CompletedPercentageWP: number;
    CompletedPercentageWS: number;
    NoOfPreviousJobs: number;
    NoOfQualifications: number;
    PersonalStatement: string;
    Achievements: string;
    IsGoogleConnected: boolean;
    IsLinkedInConnected: boolean;
    WorkExperiences: WorkExperienceModel[] = [];
    EducationCertificates: EducationModel[] = [];
    Skills: CareerSkillModel[] = [];
    Referees: RefereeModel[] = [];
    NoWorkExperience: boolean;
    NoEducationQualification: boolean;
    CurrentProfileBuilderTab: string;
    NoReference: boolean;
    PublishProfile: boolean;
    AssumedUser: boolean;
    ProfileBulderTabCompletion: {
        EDUCATION: boolean;
        PERSONAL_DATA: boolean;
        PUBLISH: boolean;
        REFERENCES: boolean;
        SKILLS: boolean;
        TEMPLATES: boolean;
        WORK_HISTORY: boolean;
    };
    Template: any;
}
