import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { JobDetailsComponent } from './job/job-details/job-details.component';
import { JobPersonalDetailsComponent } from './job/job-personal-details/job-personal-details.component';
import { JobWorkHistoryComponent } from './job/job-work-history/job-work-history.component';
import { JobsListComponent } from './jobs-list/jobs-list.component';

const routes: Routes = [
    {
        path: '',
        component: JobsListComponent
    },
    {
        path: 'new',
        component: JobDetailsComponent
    },
    {
        path: ':id',
        component: JobDetailsComponent
    },
    {
        path: ':id/personal-details',
        component: JobPersonalDetailsComponent
    },
    {
        path: ':id/work-history',
        component: JobWorkHistoryComponent
    }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class JobsRouting { }
