import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { BaseComponent } from '../../base/base.component';
import { IntroductionLetterModel } from '../../models/introduction-letter.model';
import { IntroLetterService } from '../../services/intro-letter.service';

@Component({
    selector: 'app-intro-letters',
    templateUrl: './list-intro-letters.component.html',
    styleUrls: ['./list-intro-letters.component.scss']
})
export class ListIntroLettersComponent extends BaseComponent implements OnInit {

    introLetters: IntroductionLetterModel[] = [];

    constructor(
        private introLetterService: IntroLetterService,
        private utilService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getIntroLetters();
    }

    getIntroLetters(): void {
        this.isLoading = true;
        this.introLetterService.getIntroLetters()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.introLetters = response;
            }, err => {
                this.isLoading = false;
                this.utilService.handleError(err);
        })
    }


}
