import { ActivatedRoute } from '@angular/router';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../oneit/services/utils.service';
import { ApplicantJobModel } from '../models/applicant-job.model';
import { JobService } from '../services/job.service';
import { BaseComponent } from './base.component';

export abstract class JobBaseComponent extends BaseComponent {

    applicantJobId;
    applicantJob: ApplicantJobModel = new ApplicantJobModel();
    completedView = false;

    constructor(
        protected activatedRoute: ActivatedRoute,
        protected jobService: JobService,
        protected utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit(): void {
        this.activatedRoute.params
            .pipe(takeUntil(this.componentInView))
            .subscribe(params => {
                if (params.id && params.id !== 'new') {
                    this.isEditMode = true;
                    this.applicantJobId = params.id;
                    this.getApplicantJob();
                }
            });
        this.activatedRoute.queryParams
            .pipe(takeUntil(this.componentInView))
            .subscribe(queryParams => {
                this.completedView = !!queryParams.completed;
            });
    }

    getApplicantJob(): void {
        this.isLoading = true;
        this.jobService.getApplicantJob(this.applicantJobId)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.applicantJob = response;
                this.updatedObjs[this.applicantJob.ObjectID] = this.applicantJob;
                this.jobLoaded();
            }, err => {
                this.utilsService.handleError(err);
                this.isLoading = false;
            })
    }


    abstract jobLoaded(): void;

}
