import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { ApplicantJobModel } from '../../models/applicant-job.model';
import { JobService } from '../../services/job.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';

@Component({
    selector: 'app-job',
    templateUrl: './job.component.html',
    styleUrls: ['./job.component.scss']
})
export class JobComponent extends BaseComponent implements OnInit {

    applicantJob: ApplicantJobModel = new ApplicantJobModel();

    isLoadingJobLocations = false;
    jobPostLocations = [];

    constructor(
        private jobService: JobService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.getJobPostLocations();
    }

    getJobPostLocations(): void {
        this.isLoadingJobLocations = true;
        this.jobService.getJobPostedLocation()
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoadingJobLocations = false;
                this.jobPostLocations = response;
            }, err => {
                this.isLoadingJobLocations = false;
                this.utilsService.handleError(err);
            })
    }

}
