package performa.ws;

import java.util.*;
import oneit.appservices.ws.JSONServiceRequest;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.utils.*;
import oneit.utils.parsers.FieldException;
import org.json.*;

import performa.orm.*;


public class MarkAsReadWSFP extends BaseMarkAsReadWSFP
{
    private static final long serialVersionUID  = 0L;
    public static LoggingArea LOG               = LoggingArea.createLoggingArea("MarkAsReadWSFPLOG");
    
    // This constructor should not be called
    public MarkAsReadWSFP ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    @Override
    public void processForm(JSONServiceRequest request, ObjectTransaction objTran, JSONObject result, MultiException exceptions, 
                                                Set<BaseBusinessClass> createdBBCs, Set<BaseBusinessClass> updatedBBCs) throws BusinessException, JSONException
    {
        JobApplication jobApplication = getJobApplication();
        
        try
        {
            for (Message message : jobApplication.getMessagesSet())
            {
                message.setIsRead(Boolean.TRUE);
            }
        } 
        catch (FieldException ex)
        {
            LogMgr.log(LOG, LogLevel.BUSINESS1, ex, "Failed to update as Read in MarkAsReadWSFP");
            throw new BusinessException("Failed to update as Read");
        }
    }
}