<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="../../inc/std_imports.jsp" %>

<oneit:dynIncluded>
<%
    Job         job         = (Job) process.getAttribute("Job");

    Filter      skilsFilter         = AssessmentCriteria.SearchByAll().andAssessmentType(new EqualsFilter<>(AssessmentType.SKILL));   
    Filter      qualificationFilter = AssessmentCriteria.SearchByAll().andAssessmentType(new EqualsFilter<>(AssessmentType.QUALIFICATION));   
    Filter      experienceFilter    = AssessmentCriteria.SearchByAll().andAssessmentType(new EqualsFilter<>(AssessmentType.EXPERIENCE));   
    Filter      knowledgeFilter     = AssessmentCriteria.SearchByAll().andAssessmentType(new EqualsFilter<>(AssessmentType.KNOWLEDGE));   

    Collection<AssessmentCriteria>  skills          = CollectionFilter.filter(job.getAssessmentCriteriasSet(), skilsFilter);
    Collection<AssessmentCriteria>  qualifications  = CollectionFilter.filter(job.getAssessmentCriteriasSet(), qualificationFilter);
    Collection<AssessmentCriteria>  experience      = CollectionFilter.filter(job.getAssessmentCriteriasSet(), experienceFilter);
    Collection<AssessmentCriteria>  knowledge       = CollectionFilter.filter(job.getAssessmentCriteriasSet(), knowledgeFilter);
    
    String  firstPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, "Page"), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  thirdPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.WORKPLACE_CULTURE), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  fourthPage  = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.JOB_MATCH), ProcessDecorator.getRequestParameters(request, new String[0]), "");
    String  fifthPage   = HTTPRequestDetails.getFullURL(WebUtils.getSamePageInRenderMode(request, PerformaArticleUtil.JOB_REVIEW), ProcessDecorator.getRequestParameters(request, new String[0]), "");
%>

    <script type="text/javascript">
        $(document).ready(function() {
            recalcFunction = setupRecalc($("form"));
            
            $(".switch input[type='checkbox']").each(function()
            {
                $(this).parent('span').removeClass("checked" );
                $(this).parent('span').removeClass("unchecked" );
               
                if($(this).is(":checked"))
                {
                    $(this).parent('span').addClass("checked" );
                    $( ".assessment-criteria-details" ).css( "display", "block" );
                }
                else
                {
                   $(this).parent('span').addClass("unchecked");
                   $( ".assessment-criteria-details" ).css( "display", "none" );
                }
            });
            
            $(".switch input[type='checkbox']").change(function() 
            {
                $(this).parent('span').removeClass("checked" );
                $(this).parent('span').removeClass("unchecked" );
              
                if ($(this).is(':checked')) 
                {
                    $(this).parent('span').addClass("checked" );
                    $( ".assessment-criteria-details" ).css( "display", "block" );
                } 
                else 
                {
                    $(this).parent('span').addClass("unchecked");
                    $( ".assessment-criteria-details" ).css( "display", "none" );
                }
            });
        });
    </script>
    <oneit:form name="editJob" method="post" enctype="multipart/form-data" action="<%= thirdPage %>">
        <div class="container-fluid">
            <h1 class="page-title">Create a job <span class="active-time">(Active for 30 days)</span> </h1>
            <div class="main-tab-form">
                <ul class="nav nav-pills nav-justified">
                    <li class="<%= job.jobDetailsCompleted() ? "complate" : ""%>">
                        <a href="<%= firstPage %>"><span><%= job.jobDetailsCompleted() ? "<img src=\"images/right-mark.png\" />" : "1"%></span>
                            Job Detail
                        </a>
                    </li>
                    <li class="active">
                        <a href="#"><span><%= job.assessmentCompleted() ? "<img src=\"images/right-mark.png\" />" : "2"%></span>
                            Assessment Criteria
                        </a>
                    </li>
                    <li class="<%= job.cultureCompleted() ? "complate" : ""%>">
                        <a href="<%= thirdPage %>"><span><%= job.cultureCompleted() ? "<img src=\"images/right-mark.png\" />" : "3"%></span>
                            Workplace Culture
                        </a>
                    </li>
                    <li class="<%= job.jobMatchCompleted() ? "complate" : ""%>">
                        <a href="<%= fourthPage %>"><span><%= job.jobMatchCompleted() ? "<img src=\"images/right-mark.png\" />" : "3"%></span>
                            Job Match Assessment
                        </a>
                    </li>
                    <li>
                        <a href="<%= fifthPage %>"><span>5</span>
                            Review and Submit
                        </a>
                    </li>
                </ul>
            </div>
            <div class="form-page-area">
                <div class="create-job">
                    <div class="assessment-criteria">
                        <div class="form-group">
                            <label>Include Assessment Criteria for this position? <a href="#" class="info-icon"><img src="images/info-icon.png" /></a> </label>
                            <span class="pull-right">
                                
                                <label class="switch">
                                    <oneit:ormInput obj="<%= job %>"    attributeName="IncludeAssessmentCriteria"   type="checkbox"/>
                                    <div class="slider round"></div>
                                </label>
                            </span>
                        </div>
                        
                        <div class="assessment-criteria-details">
                            <div class="form-group">
                                <select class="form-control">
                                    <option>Optional: Select previously defined Assessment Criteria</option>
                                    <option>One 1</option>
                                    <option>One 2</option>
                                    <option>One 3</option>
                                </select>              
                            </div>              
                            <div class="form-brack-line-sub"></div>              
                            <div class="form-group">
                                <div class="form-medium-title">
                                    Skills
                                    <%
                                        if(skills.size() == 0)
                                        {
                                    %>
                                            <span class="skill-label">No skills currently added for this role.</span>
                                    <%
                                        }
                                    %>
                                </div>
                                <div class="main-add-more">
                                    <div class="add-more-btn"><img src="images/plus-img.png"> Add SKill</div>
                                </div>
                            </div>
                            <div class="form-brack-line-sub"></div>
                            <div class="form-group">
                                <div class="form-medium-title qualification-title">
                                    Qualification 
                                    <%
                                        if(qualifications.size() > 0)
                                        {
                                    %>
                                            <span class="skill-label">
                                                <oneit:toString value="<%= qualifications.size() %>" mode="EscapeHTML"/> Qualification added
                                            </span>
                                    <%
                                        }
                                        else
                                        {
                                    %>
                                            <span class="skill-label">No qualifications currently added for this role.</span>
                                    <%
                                        }
                                    %>
                                </div>
                                <%
                                    for (AssessmentCriteria qualification : qualifications)
                                    {
                                %>
                                        <div class="main-qualification">
                                            <span class="delete-qualification"><span></span></span>
                                            <oneit:ormInput obj="<%= qualification %>"  type="text" attributeName="Name"    cssClass="form-control" />
                                            <div class="radio radio-primary qualification-radio">
                                                <input type="radio" name="radio1" id="radio5" value="option1" checked="">
                                                <label for="radio5">
                                                    Essential
                                                </label>
                                            </div>
                                            <div class="radio radio-primary qualification-radio">
                                                <input type="radio" name="radio1" id="radio6" value="option1">
                                                <label for="radio6">
                                                    Highly Desirable
                                                </label>
                                            </div>
                                            <div class="radio radio-primary qualification-radio">
                                                <input type="radio" name="radio1" id="radio7" value="option1">
                                                <label for="radio7">
                                                    Desirable
                                                </label>
                                            </div>
                                        </div>
                                <%
                                    }
                                %>
                                <div class="main-add-more">
                                  <div class="add-more-btn"><img src="images/plus-img.png"> Add Qualification</div>
                                </div>
                            </div>
                            <div class="form-brack-line-sub"></div>
                            <div class="form-group">
                                <div class="form-medium-title">
                                    Experience
                                    <%
                                        if(experience.size() == 0)
                                        {
                                    %>
                                            <span class="skill-label">No experience currently added for this role.</span>
                                    <%
                                        }
                                    %>
                                </div>
                                <div class="main-add-more">
                                    <div class="add-more-btn"><img src="images/plus-img.png"> Add Experience</div>
                                </div>
                            </div>
                            <div class="form-brack-line-sub"></div>
                            <div class="form-group">
                                <div class="form-medium-title">
                                    Knowledge
                                    <%
                                        if(knowledge.size() == 0)
                                        {
                                    %>
                                            <span class="skill-label">No knowledge currently added for this role.</span>
                                    <%
                                        }
                                    %>
                                </div>
                                <div class="main-add-more">
                                    <div class="add-more-btn"><img src="images/plus-img.png"> Add Experience</div>
                                </div>
                            </div>
                            <div class="form-brack-line-sub"></div>
                            <div class="form-group">
                                <div class="save-assess">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" checked>
                                        <label for="checkbox2">
                                          Save this Assessment Criteria as a template
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group input-group-lg">                    
                                    <div class="icon-addon addon-lg">
                                        <input type="text" placeholder="Template Name" class="form-control" id="email">
                                    </div>
                                    <span class="input-group-btn">
                                        <button class="btn btn-primary" type="button">SAVE</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                          <input type="button" class="btn btn-primary top-margin-25" value="Proceed to Workplace Culture" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>