package performa.utils;

import javax.servlet.http.HttpServletRequest;
import oneit.business.content.Article;
import oneit.business.content.jsp.*;
import oneit.objstore.ObjectTransaction;


public class PerformaArticleUtil
{
    public static final String CLIENT_PORTAL    = "ClientPortal";
    public static final String JOB_PORTAL       = "JobApplicationEngine";
    public static final String CLIENT_HOME      = "ClientHome";
    public static final String JOB_HOME         = "JobHome";
    
    public static boolean descendsFrom (Article article, String parentArticleIdFilter)
    {
        if (article.getIdentifier ().equals (parentArticleIdFilter))
        {
            return true;
        }
        else if (article.getCategory () != null && article.getCategory () != article)
        {
            return descendsFrom(article.getCategory (), parentArticleIdFilter);
        }
        else
        {
            return false;
        }
    }
    
    public static String getPortalName(ObjectTransaction objTran, Article article, Article clientArticle, Article jobArticle)
    {   
        if(clientArticle != null)
        {
            if(descendsFrom(article, clientArticle.getIdentifier()))
            {
                return CLIENT_PORTAL;
            }
        }
        
        if(jobArticle != null)
        {
            if(descendsFrom(article, jobArticle.getIdentifier()))
            {
                return JOB_PORTAL;
            }
        }
        
        return "";
    }
    
    public static Article getArticleByShortCut(ObjectTransaction objTran, String shortCut)
    {
        return ShortcutFilter.doShortcutSearch(objTran, shortCut);
    }
    
    public static String getEventLink(Article eventArticle, HttpServletRequest request, Long eventID)
    {
        if(eventArticle != null)
        {
            return eventArticle.getLink(request) + "?EventID=" + eventID; 
        }
        
        return "";
    }
}
