<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String          hiringTeamList  =   WebUtils.getSamePageInRenderMode(request, "Page");
    String          homePage        =   WebUtils.getArticleByShortCut(process.getTransaction(), WebUtils.ADMIN_HOME).getLink(request);
    SecUser         loggedInUser    =   SecUser.getTXUser(transaction);
    CompanyUser     companyUser     =   loggedInUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    Company         company         =   companyUser.getCompany();
    HiringTeam      hiringTeam      =   (HiringTeam) process.getAttribute("HiringTeam");

    Debug.assertion(company != null , "Invalid company in admin portal my company");
    
    Debug.assertion(hiringTeam != null , "Invalid Hiring Team in admin portal manage plan");
  
    PaymentPlan[]   paymentPlans    =   PaymentPlan.SearchByAll()
                                                    .andDisabled(new EqualsFilter<>(Boolean.FALSE))
                                                    .andUsageType(new EqualsFilter<>(UsageType.LICENSED))
                                                    .andActiveJobCount(new GreaterThanFilter<>(0))
                                                    .andCurrencyType(new EqualsFilter<>(hiringTeam.getCountry().getCurrency()))
                                                    .search(transaction);
        
    List<PaymentPlan>   sortedPlans =   ObjstoreUtils.sort(Arrays.asList(paymentPlans), 
                                                        new ObjectTransform[]{PaymentPlan.pipesPaymentPlan().toActiveJobCount()}, 
                                                        new Comparator[]{CollectionUtils.DEFAULT_COMPARATOR_NULLS_FIRST});

    Subscription    subscription    =   null;
    PaymentPlan     currentPlan     =   hiringTeam.getPaymentPlan();
    boolean         hasValidCoupon  =   hiringTeam.hasValidCoupon();

    if(currentPlan != null && hiringTeam.getStripeSubscription() != null)
    {
        subscription    =   StripeUtils.retrieveSubscription(hiringTeam.getStripeSubscription());
    }
    
    String  currencyFormat  =   Utils.getCurrencyFormat(hiringTeam);
    boolean firstTime       =   hiringTeam.getIsPPJ() == null || (!hiringTeam.getIsPPJ() && hiringTeam.getPaymentPlan() == null);
    String  nextPage        =   firstTime ? homePage : WebUtils.getSamePageInRenderMode(request, "ManagePlan");
%>
    <style>
        .select-button input[type=radio] {
            position: absolute;
            visibility: hidden;
        }
    </style>
    <script type="text/javascript">
        var Popup = null;
        var PopupCoupon = null;
        var PopupAlert = null;
        $(document).ready(function()
        {
            setTabingSideBarHeight();
            
            recalcFunction = setupRecalc ($("form#editCompany"), {'recalcOnError':true});
       
            Popup = new jBox('Modal', {
                  id : "change-plan",
                  overlay : true, 
                  width : 600, height : 640
                  });
                  
            PopupCoupon = new jBox('Modal', {
                    id : "change-plan",
                    overlay : true, 
                    width : 500, height : 400
                    });            
         
            PopupAlert = new jBox('Modal', {
                    id : "change-plan",
                    overlay : true, 
                    width : 350, height : 300
                    });            
         
            var isinvliadCoupon = getParameterByName("invalidcoupon");

            if (isinvliadCoupon==='true'){
                PopupCoupon.setContent($("#invalid-coupon-popup"));
                PopupCoupon.open();
            }

            $(".invalid-coupon-close-button").on("click",function(){             
                PopupCoupon.close();               
            });  
            $(".alert-close-button").on("click",function(){       
                PopupAlert.close();
            });  

            $(".change-plan-no-button").on("click",function(){             
                Popup.close();
            });               

            $(".select-btn-popup").on("click",function(){             
                Popup.setContent($("#" + $(this).data('popupid')  ));
                Popup.open();
            }); 
            
            $(".manage-plan-row input").on("change", function(){
                setTabingSideBarHeight();
            });
            disableOutSideWhileChoosePlan();
            
            $(document).on("click",".plan-selection input",function(e) 
                    {
                       disableOutSideWhileChoosePlan();
                        
                    });
            
        }); 
        
        function disableOutSideWhileChoosePlan(){
            if ($(".manage-plan-hidden-info").is(":visible")){
                if(!$(".choose-plan-item.active").length){
                    $("a ").each(function(){
                        if ( !$(this).parents(".choose-plan-wrap").length ) { 
                            if($(this).prop("tagName") === "A"){
                                $(this).prop("onclick", null).off("click");
                                $(this).css("cursor","arrow").click(function(){
                                    
                                     if ($(this).hasClass("invalid-coupon-close-button")){  
                                            PopupCoupon.close();
                                        }
                                        else if ($(this).hasClass("alert-close-button")){  
                                              PopupAlert.close();
                                        }
                                        else if ($(this).hasClass("change-plan-no-button")){  
                                              Popup.close();
                                        }
                                        else if ($(this).hasClass("contact-us")){  
                                              Popup.close();
                                        }else{
                                            PopupAlert.setContent($("#force-to-choose-popup"));    
                                            PopupAlert.open();                                      
                                            return false;
                                        }
                                });
                            }
                                
                        }
                    });
                }
            }
        }
        
        function savePaymentPlan(){
            $("#savePaymentPlan").click();
        }
        
        function saveCap(){
            $("#saveCap").click();
        }
        
        function changePPJ(){
            $("#savePPJ").click();
        }
        
        function changeSubscribe(){
            $("#saveSubscribe").click();
        }
    </script> 
    <div class="overlayx"></div>
    <div class="container-fluid">
        <div class="row content">
            <div class="main-content-area">
                <oneit:form name="editCompany"  method="post"    enctype="multipart/form-data">
                    
                    <h1 class="page-title page-title-with-arrow">
                        <oneit:button   cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", hiringTeamList)
                                                                            .mapEntry("cancelProcess", true)
                                                                            .toMap() %>" >
                            <img src="images/arrow-left-prev_blue.svg" />
                        </oneit:button>
                        <%= hiringTeam.getHiringTeamName() %>
                    </h1>
                    <div class="my-company-area">
                        
                        <div style="padding-left: 15px; padding-right: 15px;">
                            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                        </div>

                        <oneit:dynInclude   page="/extensions/adminportal/inc/my_company_tabs.jsp"    TabNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

                        <div class="company-content-area">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="choose-plan-wrap">
                                <div class="tab-pane active" id="company-detail">
                                    <div>  
                                        <div class="tabpage-title manage-plan">
                                            <label class="label-20">Manage Plan</label>                
                                        </div>
                                        <div class="apply-coupon">
                                            <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="CouponCode"   placeholder="Coupon Code"  cssClass="form-control" />      
                                            <oneit:button   value="APPLY"     name="applyCoupon"    cssClass="btn btn-input-inside"
                                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                            .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                            .mapEntry ("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                                            .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                                            .toMap() %>" />
                                        </div>
                                    </div>
                                    <%
                                        if(hasValidCoupon)
                                        {
                                            StripeCoupon    coupon  =   hiringTeam.getCoupon();
                                    %>
                                            <div class="coupon-applied-alert">
                                                coupon applied 
                                                <span class="coupon_code">
                                                    <oneit:toString value="<%= coupon.getCouponCode()%>" mode="EscapeHTML"/> - save
                                                    <oneit:toString value="<%= coupon.getPercentageOff()%>" mode="PercentageWholeNumber"/>
                                                </span>
                                                <%
                                                    if(hiringTeam.getCouponExpiryDate() != null)
                                                    {
                                                %>
                                                    <span class="expire">
                                                        Expires
                                                        <oneit:toString value="<%= hiringTeam.getCouponExpiryDate() %>" mode="MidDate"/>
                                                    </span>
                                                <%
                                                    }
                                                %>
                                            </div>
                                    <%
                                        }

                                        // temp solution. SimpleAssocHandler sets null value for plan as it is not visible in the form when PPJ is selected.
                                        // Problem occurs when shifting from PPJ to Subscription
                                        if(hiringTeam.getPaymentPlan() != null)
                                        {
                                            String  paymentPlanKey =   WebUtils.getRadioSingleAssocKey(request, hiringTeam, HiringTeam.SINGLEREFERENCE_PaymentPlan);
                                            String  paymentPlanId  =   String.valueOf(hiringTeam.getPaymentPlan().getID().longID());

                                    %>
                                            <input type="radio" name="<%= paymentPlanKey %>" id="<%= paymentPlanId %>"  class="hide" value="<%= paymentPlanId %>" checked/>
                                    <%
                                        }
                                    %>
                                                                            
                                    <div class="form-group row">
                                        <div class="col-md-12 oneit-radio coupon-applied">
                                            <div class="rectangle-5">
                                                <div class="manage-plan-row">
                                                    <div class="radio">
                                                        <label class="plan-selection">
                                                            <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="IsPPJ" value="true" onchange="<%= firstTime ? "return false;" : "changePPJ()" %>"/>
                                                        </label>
                                                    </div>
                                                    <oneit:button   value=" " name="savePlan"   cssClass="hide"  id="savePPJ"
                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                    .mapEntry ("savePPJ", Boolean.TRUE)
                                                                                                    .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                                    .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                                    .toMap() %>" />
                                                    <div class="manage-plan-title">
                                                        <h3>Pay Per Job</h3>                                                        
                                                        <span>
                                                            You'll be charged each time you add a new job
                                                        </span>
                                                    </div>
                                                    <div class="manage-plan-payplan">
                                                        <div class="per-job-amount">
                                                            <oneit:toString value="<%= hiringTeam.getPPJAmount(null) %>" mode="<%= currencyFormat %>"/>/ Job
                                                        </div>
                                                        <%
                                                            if(hasValidCoupon)
                                                            {
                                                        %>
                                                                <div class="per-job-amount-past">
                                                                    was <oneit:toString value="<%= hiringTeam.getPPJAmount() %>" mode="<%= currencyFormat %>"/> per job
                                                                </div>
                                                        <%
                                                            }
                                                        %>
                                                    </div>
                                                    <div class="clearboth"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12 oneit-radio  coupon-applied">                                             
                                            <div class="rectangle-5">
                                                <div class="manage-plan-row">
                                                    <div class="radio">
                                                        <label class="plan-selection">
                                                            <oneit:ormInput obj="<%= hiringTeam %>" type="radio" attributeName="IsPPJ" value="false"    onchange="<%= firstTime ? "return false;" : "changeSubscribe()" %>"/>
                                                        </label>
                                                    </div>
                                                    <oneit:button   value=" " name="savePlan"   cssClass="hide"  id="saveSubscribe"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                .mapEntry ("savePPJ", Boolean.TRUE)
                                                                                                .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                                .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                                .toMap() %>" />
                                                    <div class="manage-plan-title">
                                                        <h3>Subscribe & Save</h3>                                                        
                                                        <span>
                                                            Intend to post multiple jobs this month?<br>
                                                            Find a plan to suit your hiring needs, and save today.
                                                        </span>
                                                    </div>
                                                    <div class="manage-plan-payplan">
                                                        <div class="per-job-amount">
                                                        </div>
                                                        <div class="per-job-amount-past">
                                                        </div>
                                                    </div>
                                                    <div class="clearboth"></div>
                                                </div>
                                                <div class="manage-plan-hidden-info">  
                                                <%
                                                    if(subscription != null)
                                                    {

                                                        int     dayOfMonth  =   Utils.getDayOfMonth(new Date(subscription.getCurrentPeriodEnd() * 1000));
                                                        String  suffix      =   Utils.getDayNumberSuffix(dayOfMonth);
                                                %>
                                                        <div class="subscription-billed">
                                                            <img src="images/icon-calendar.png"> Your subscription is billed and resets on the <%= dayOfMonth %><%= suffix %> of every month
                                                        </div>
                                                <%
                                                    }
                                                %>
                                                    <div class="choose-plan-row">    
                                                        <div class="choose-your-plan-title">
                                                            Choose Your Plan
                                                        </div>
                                                        <div class="choose-plan-headings">  
                                                            <div class="jobs-per-month">Jobs Per Month</div>
                                                            <div class="cost-per-job">Cost Per Job</div>
                                                            <div class="monthly-fee">Monthly Fee</div>
                                                        </div>
                                                    <%
                                                        for (PaymentPlan paymentPlan : sortedPlans)
                                                        {
                                                            boolean     isSelectedPlan  =   CollectionUtils.equals(paymentPlan, currentPlan);
                                                    %>

                                                            <oneit:recalcClass  htmlTag="div"    classScript="hiringTeam.isPlanActive(paymentPlan) ? 'choose-plan-item active' : 'choose-plan-item' "  hiringTeam="<%= hiringTeam %>"    paymentPlan="<%= paymentPlan %>">
                                                                <div class="jobs">
                                                                    <%= paymentPlan.getActiveJobCount() %> Jobs 
                                                                </div>
                                                                <div class="cost <%= hasValidCoupon ? "discounted" : ""%>">
                                                                    <oneit:toString value="<%= paymentPlan.getAmountPerJob(hiringTeam) %>"  mode="<%= currencyFormat %>"/>
                                                                    <%
                                                                        if(hasValidCoupon)
                                                                        {
                                                                    %>
                                                                            <span class="past-val">
                                                                                Was <oneit:toString value="<%= paymentPlan.getAmount() / paymentPlan.getActiveJobCount() %>" mode="<%= currencyFormat %>"/>
                                                                            </span>
                                                                    <%
                                                                        }
                                                                    %>
                                                                </div>
                                                                <div class="fee <%= hasValidCoupon ? "discounted" : ""%>">
                                                                    <oneit:toString value="<%= paymentPlan.getTotalAmount(hiringTeam) %>" mode="<%= currencyFormat %>"/><span class="month"> / month </span>
                                                                    <%
                                                                        if(hasValidCoupon)
                                                                        {
                                                                    %>
                                                                            <span class="past-val">
                                                                                Was <oneit:toString value="<%=  paymentPlan.getAmount() %>" mode="<%= currencyFormat %>"/>
                                                                            </span>
                                                                    <%
                                                                        }
                                                                    %>
                                                                </div>
                                                                <div class="select-button">
                                                                    <oneit:button   skin="link" value=" "     name="savePlan"      cssClass="btn select-btn" style="display:none;"
                                                                                            requestAttribs="<%= CollectionUtils.EMPTY_MAP%>" />
                                                                    <%
                                                                        if(isSelectedPlan)
                                                                        {
                                                                    %>
                                                                            <span class="btn active-btn">Active</span>
                                                                    <%
                                                                        }
                                                                        else if(currentPlan != null && subscription != null)
                                                                        {
                                                                            boolean isUpgrade       =   paymentPlan.getActiveJobCount() > currentPlan.getActiveJobCount();
                                                                            int     remainingJobs   =   isUpgrade ? ( paymentPlan.getActiveJobCount() - hiringTeam.getUsedCredits()) : hiringTeam.getRemainingJobs();
                                                                    %>
                                                                            <a href="#" class="btn select-btn select-btn-popup" data-popupid ="change-plan-popup-<%=paymentPlan.getID()%>" >Select</a>
                                                                            
                                                                            <div id="change-plan-popup-<%=paymentPlan.getID()%>" style="display:none" >
                                                                                <div class="change-plan-content">
                                                                                    <h3>
                                                                                        <%= isUpgrade ? "Upgrade" : "Change" %> to <%= paymentPlan.getActiveJobCount() %> Jobs per month?
                                                                                    </h3>
                                                                                    <div class="upgrade-info">
                                                                                        <%
                                                                                            boolean validCoupon     =   hiringTeam.hasValidCouponOn(new Date(subscription.getCurrentPeriodEnd() * 1000));
                                                                                            double  currentPlanCost =   hiringTeam.getLastPlanAmount() != null ? hiringTeam.getLastPlanAmount() : currentPlan.getAmount();
                                                                                            double  newPlanCost     =   validCoupon ?  paymentPlan.getAmount() * (1 - (hiringTeam.getCoupon().getPercentageOff() * 0.01)) : paymentPlan.getAmount();
                                                                                            double  costDiff        =   newPlanCost - currentPlanCost;

                                                                                            if(isUpgrade)
                                                                                            {
                                                                                        %>
                                                                                                Upgrading your plan to <%= paymentPlan.getActiveJobCount() %> Jobs per month will incur an additional cost of 
                                                                                                <%= FormatUtils.stringify(costDiff, currencyFormat, "") %> be billed immediately. 
                                                                                                <span>
                                                                                                    This cost is to cover the difference between your current active <%= currentPlan.getActiveJobCount() %> job plan (<%= FormatUtils.stringify(currentPlanCost, currencyFormat, "") %>) 
                                                                                                    and the new <%= paymentPlan.getActiveJobCount() %> job plan (<%= FormatUtils.stringify(newPlanCost, currencyFormat, "") %>).
                                                                                                </span>
                                                                                        <%
                                                                                            }
                                                                                            else
                                                                                            {
                                                                                        %>
                                                                                                Changing your plan down to 5 Jobs per month will not incur any additional costs, and will begin on <%= FormatUtils.stringify(new Date(subscription.getCurrentPeriodEnd() * 1000), "LongDate", "")%>.
                                                                                                <span>
                                                                                                    Because your plan has already been billed, your new plan will commence at the beginning of the next billing period.                               
                                                                                                </span>
                                                                                        <%
                                                                                            }
                                                                                        %>
                                                                                    </div>
                                                                                    <div class="change-plan-list">
                                                                                        <div class="list-item">
                                                                                            <span class="item-title">Jobs remaining this month</span>
                                                                                            <span class="item-value"><%= remainingJobs %> Job Remaining</span>
                                                                                        </div>
                                                                                        <div class="list-item">
                                                                                            <span class="item-title">Date your plan will reset</span>
                                                                                            <span class="item-value"><oneit:toString  value="<%= new Date(subscription.getCurrentPeriodEnd() * 1000) %>"   mode="LongDate"/></span>
                                                                                        </div>
                                                                                        <div class="list-item">
                                                                                            <span class="item-title">Date of next billing period</span>
                                                                                            <span class="item-value"><%= FormatUtils.stringify(newPlanCost, currencyFormat , "") %> on <oneit:toString  value="<%= new Date(subscription.getCurrentPeriodEnd() * 1000) %>"   mode="LongDate"/></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="upgrade-info">
                                                                                        <span>
                                                                                            Would you like to proceed with <%= isUpgrade ? "upgrading your account?" : "this change?" %>
                                                                                        </span>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="change-plan-button">
                                                                                    <a class="change-plan-no-button popup-no-button">No</a>
                                                                                    <oneit:button   skin="link" value="Yes"     name="savePlan"      cssClass="change-plan-yes-button"
                                                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                                                .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                                                .mapEntry ("savePlan", Boolean.TRUE)
                                                                                                                                .mapEntry ("PaymentPlan", paymentPlan)
                                                                                                                                .mapEntry ("procParams", CollectionUtils.mapEntry("HiringTeam", hiringTeam).toMap())
                                                                                                                                .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                                                                .toMap() %>" />

                                                                                </div>
                                                                            </div> 
                                                                    <%
                                                                        }
                                                                        else
                                                                        {
                                                                            String  planKey =   WebUtils.getRadioSingleAssocKey(request, hiringTeam, HiringTeam.SINGLEREFERENCE_PaymentPlan);
                                                                            String  planId  =   String.valueOf(paymentPlan.getID().longID());
                                                                    %>
                                                                            <input type="radio" name="<%= planKey %>" id="<%= planId %>"  class="level_radio" value="<%= planId %>"/>
                                                                            <label for="<%= planId %>">
                                                                                <oneit:recalcClass  htmlTag="a"    classScript="hiringTeam.isPlanActive(paymentPlan) ? 'btn active-btn' : 'btn select-btn' "  hiringTeam="<%= hiringTeam %>"    paymentPlan="<%= paymentPlan %>">
                                                                                    <oneit:recalc   mode="EscapeHTML"   script="hiringTeam.isPlanActive(paymentPlan) ? 'Active' : 'Select' " hiringTeam="<%= hiringTeam %>"    paymentPlan="<%= paymentPlan %>"    nullValue=""/>
                                                                                </oneit:recalcClass>
                                                                            </label>    
                                                                    <%
                                                                        }
                                                                    %>
                                                                </div>
                                                            </oneit:recalcClass>
                                                    <%
                                                        }
                                                    %>                                                                    
                                                            <div class="additional-jobs-over">
                                                                <span class="blue-alert">
                                                                    Additional jobs over plan allowance are billed at the Cost Per Job for the subscription level
                                                                </span>
                                                                <span>
                                                                    Would you like to set a maximum limit on the total jobs able to be posted
                                                                </span>
                                                            </div>
                                                            <div class="set-a-cap-option">
                                                                <div >
                                                                    <span> No, leave it open</span>
                                                                    <label class="switch">
                                                                        <oneit:recalcClass  htmlTag="span"  classScript="hiringTeam.isTrue(hiringTeam.getHasCap()) ? 'checkbox checked': 'checkbox unchecked'"    hiringTeam="<%= hiringTeam %>">
                                                                            <oneit:ormInput obj="<%= hiringTeam %>"    attributeName="HasCap"   type="checkbox" onChange="<%= firstTime ? "return false;" : "savePaymentPlan()" %>"/>
                                                                        </oneit:recalcClass>
                                                                        <div class="slider round"></div>
                                                                    </label>
                                                                    <span>Yes, set a cap</span>
                                                                </div>
                                                            </div>
                                                            <div class="setmax">
                                                                <oneit:recalcClass  htmlTag="div"  classScript="hiringTeam.isTrue(hiringTeam.getHasCap()) ? 'show': 'hide'"    hiringTeam="<%= hiringTeam %>">
                                                                    <oneit:ormInput obj="<%= hiringTeam %>"    type="text" attributeName="MaxCap"    cssClass="form-control" />      
                                                                    <a class="btn btn-primary" onClick="<%= firstTime ? "return false;" : "saveCap()" %>">Set Max</a>
                                                                    <oneit:button   value="Set Max"     name="savePlan" cssClass="btn btn-primary hide" id="saveCap"
                                                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                                                        .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                                                        .mapEntry ("saveCap", Boolean.TRUE)
                                                                                                                        .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                                                        .toMap() %>" />
                                                                </oneit:recalcClass>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <div class="form-group row">
                                        <div class="text-center form-group">
                                            <oneit:button   value="Save Plan" name="savePlan"   cssClass="<%= "btn btn-primary largeBtn save-btn " + ( firstTime ? "" : "hide")%>"  id="savePaymentPlan"
                                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                            .mapEntry ("restartProcess", Boolean.TRUE)
                                                                                            .mapEntry ("firstTime", firstTime)
                                                                                            .mapEntry(NotificationUtils.DISPLAY_NOTIFICATION_PARAM, false)
                                                                                            .mapEntry ("attribNamesToRestore", Collections.singleton("HiringTeam"))
                                                                                            .toMap() %>" />
                                        </div> 
                                    </div>
                                    <div class="text-center footer-note">
                                        Looking to cancel your account? Please <a href=" https://www.talentology.com/support/" target="_blank">contact us.</a>
                                    </div>
                                </div>
                                     
                                <div id="invalid-coupon-popup" style="display:none" >
                                    <div class="change-plan-content">
                                        <h3>Oops!</h3>
                                        <div class="upgrade-info">
                                            <span>We're having some difficulty validating your coupon. <br> Please check the code supplied and try again.</span>
                                            <span>For further assistance, please <a class="contact-us" href=" https://www.talentology.com/support/"  target="_blank">contact us.</a></span>
                                        </div>
                                    </div>
                                    <div class="change-plan-button">
                                        <a class="invalid-coupon-close-button popup-no-button">Close & Retry</a>
                                    </div>        
                                </div>           

                                <div id="force-to-choose-popup" style="display:none" >
                                    <div class="change-plan-content">
                                        <h3>Alert!</h3>
                                        <div class="upgrade-info">
                                            <span>Please select a plan.</span>
                                        </div>
                                    </div>
                                    <div class="change-plan-button">
                                        <a class="alert-close-button popup-no-button">Ok</a>
                                    </div>        
                                </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </oneit:form>
            </div>
        </div>
    </div>
                                                        
             
      
                                                         
</oneit:dynIncluded>
