
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class JobApplicationPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea JobApplicationPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "JobApplication");

    // Private attributes corresponding to business object data
    private BinaryContent dummyCV;
    

    // Static constants corresponding to attribute helpers
    private static final BLOBAttributeHelper HELPER_CV = BLOBAttributeHelper.INSTANCE;
    



    public JobApplicationPersistenceMgr ()
    {
        dummyCV = (BinaryContent)(HELPER_CV.initialise (dummyCV));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_job_application.object_id as id, {PREFIX}tl_job_application.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_job_application.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_job_application.cv, {PREFIX}tl_job_application.candidate_id, {PREFIX}tl_job_application.job_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, JobApplication.REFERENCE_JobApplication);

                if (objectToReturn instanceof JobApplication)
                {
                    LogMgr.log (JobApplicationPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a JobApplication");
                }
            }

            PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(id, "tl_job_application", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_job_applicationPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_job_applicationPSet.containsAttrib(JobApplication.FIELD_CV)||
                    !tl_job_applicationPSet.containsAttrib(JobApplication.SINGLEREFERENCE_Candidate)||
                    !tl_job_applicationPSet.containsAttrib(JobApplication.SINGLEREFERENCE_Job))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (JobApplicationPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                JobApplication result = new JobApplication ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job_application " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_job_application.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (JobApplication.SINGLEREFERENCE_Candidate))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job_application " +
                            "WHERE " + SELECT_JOINS + "candidate_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (JobApplication.SINGLEREFERENCE_Job))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_job_application " +
                            "WHERE " + SELECT_JOINS + "job_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(objectID, "tl_job_application");
            

            
            if (tl_job_applicationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_job_applicationPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_job_application " +
                                                           "SET cv = ?, candidate_id = ? , job_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_job_application.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_CV.getForSQL(dummyCV, tl_job_applicationPSet.getAttrib (JobApplication.FIELD_CV))).listEntry (SQLManager.CheckNull((Long)(tl_job_applicationPSet.getAttrib (JobApplication.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(tl_job_applicationPSet.getAttrib (JobApplication.SINGLEREFERENCE_Job)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_job_application WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_job_application", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (JobApplicationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_job_application");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_job_application for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (JobApplicationPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_job_applicationPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (JobApplicationPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(objectID, "tl_job_application");
        

        LogMgr.log (JobApplicationPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_job_applicationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_job_applicationPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_job_application " +
                                                       "WHERE tl_job_application.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_job_application WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_job_application");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_job_application for row:" + objectID;

                    LogMgr.log (JobApplicationPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_job_applicationPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    public ResultSet executeSearchQueryCandidateJob (SQLManager sqlMgr, Candidate Candidate, Job Job) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryCandidateJob");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, JobApplication> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (JobApplication.REFERENCE_JobApplication.getObjectIDSpace (), r.getLong ("id"));
            JobApplication resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, JobApplication.REFERENCE_JobApplication);

                if (cachedElement instanceof JobApplication)
                {
                    LogMgr.log (JobApplicationPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (JobApplication)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a JobApplication");
                }
            }
            else
            {
                PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(objectID, "tl_job_application", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new JobApplication ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (JobApplicationPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_job_application " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (JobApplication.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_job_application.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job_application.object_id is not null
                    String preFilter = "(tl_job_application.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job_application " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (JobApplication.SEARCH_CandidateJob))
        {
            // Local scope for transformed variables
            {
                
                if (criteria.containsKey("Candidate"))
                {
                Candidate Candidate = (Candidate)(criteria.get("Candidate"));
                criteria.put ("Candidate", Candidate.getObjectID());
                }
                if (criteria.containsKey("Job"))
                {
                Job Job = (Job)(criteria.get("Job"));
                criteria.put ("Job", Job.getObjectID());
                }
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_job_application.object_id is not null
                    String preFilter = "(tl_job_application.object_id is not null)"
                                     + "  ";
                    
                        if (criteria.containsKey("Candidate"))
                        {
                            preFilter += " AND (candidate_id = ${Candidate} ) ";
                            preFilter += "";
                            
                        }
                    
                        if (criteria.containsKey("Job"))
                        {
                            preFilter += " AND (job_id = ${Job}) ";
                            preFilter += "";
                            
                        }
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_job_application " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(objectID, "tl_job_application", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_job_applicationPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_job_applicationPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_job_applicationPSet.setAttrib(JobApplication.FIELD_CV, HELPER_CV.getFromRS(dummyCV, r, "cv"));
        
        tl_job_applicationPSet.setAttrib(JobApplication.SINGLEREFERENCE_Candidate, r.getObject ("candidate_id"));
        tl_job_applicationPSet.setAttrib(JobApplication.SINGLEREFERENCE_Job, r.getObject ("job_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_job_applicationPSet = allPSets.getPersistentSet(objectID, "tl_job_application");
        

        
        if (tl_job_applicationPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_job_applicationPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_job_application " +
                                     "  (cv,  candidate_id, job_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_CV.getForSQL(dummyCV, tl_job_applicationPSet.getAttrib (JobApplication.FIELD_CV))) .listEntry (SQLManager.CheckNull((Long)(tl_job_applicationPSet.getAttrib (JobApplication.SINGLEREFERENCE_Candidate)))).listEntry (SQLManager.CheckNull((Long)(tl_job_applicationPSet.getAttrib (JobApplication.SINGLEREFERENCE_Job)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_job_applicationPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
