package performa.utils;

import com.google.maps.DistanceMatrixApi;
import com.google.maps.DistanceMatrixApiRequest;
import com.google.maps.GeoApiContext;
import com.google.maps.model.Distance;
import com.google.maps.model.DistanceMatrix;
import java.io.IOException;
import oneit.appservices.config.ConfigMgr;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;

public class DistanceUtils 
{
    private static final String API_KEY=   ConfigMgr.getKeyfileString("google.api.key","AIzaSyCaBh-MsMb8BBYJD_NcFzoCmygQbt5-QSw");

    public static Distance calculateDistance(String origin, String destination)
    {
        try 
        {
            DistanceMatrixApiRequest    req     =   DistanceMatrixApi.newRequest(new GeoApiContext.Builder().apiKey(API_KEY).build());
            DistanceMatrix              trix    =   req.origins(new String[]{origin})
                                                        .destinations(new String[]{destination})
                                                        .await();
            
            return trix.rows[0].elements[0].distance;

        } 
        catch (com.google.maps.errors.ApiException | InterruptedException | IOException e) 
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, e, "Error while retrieving distance via google distance matrix api. origin: " + origin + " destination: " + destination);
        }

        return null;
    }
}
