package performa.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oneit.appservices.config.ConfigMgr;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.utils.text.FormatUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CenterTextMode;
import org.jfree.chart.plot.RingPlot;
import org.jfree.data.general.DefaultPieDataset;


public class RingChart 
{
    public  static  final   String  tempURLBase =   ConfigMgr.getConfigString("CONFIG.GLOBAL", "DocTempURLBase");
    public  static  final   Color   RED         =   Color.decode("#FB5D67");
    public  static  final   Color   GREY        =   Color.decode("#E5E8EB");
    public  static  final   Color   AMBER       =   Color.decode("#FBD44E");
    public  static  final   Color   GREEN       =   Color.decode("#41BDB4");
    
    private DefaultPieDataset   dataset;
    private final List<Color>   colors      =   new ArrayList<>();
    private final int           height      =   150;
    private final int           width       =   150;
    private String              fileName    =   "ringchart.jpeg";
    
    public RingChart()
    {
        this.dataset    =   new DefaultPieDataset();
    }
    
    public RingChart(String filename)
    {
        this();
        this.fileName   =   filename;
    }
    
    public RingChart addData(String cat, Number val, Color color)
    {
        dataset.setValue(cat, val);
        colors.add(color);
        
        return this;
    }
    
    public String getChartImage()
    {
        return getChartImage(width, height);
    }
    
    public String getChartImage(int width, int height)
    {
        JFreeChart  chart   =   ChartFactory.createRingChart("", dataset, false, false, Locale.ENGLISH);
        RingPlot    plot    =   (RingPlot) chart.getPlot();
        
        for (int i = 0; i < dataset.getItemCount(); i++)
        {
            if(i == 0)
            {
                plot.setCenterText(FormatUtils.stringify(dataset.getValue(i), "PercentageWholeNumber", "0"));
            }
            
            plot.setSectionPaint(dataset.getKey(i), colors.get(i));
            plot.setSectionOutlinePaint(dataset.getKey(i), Color.BLACK);
            plot.setSectionOutlineStroke(dataset.getKey(i), new BasicStroke(2));
        }
        
        plot.setBackgroundPaint(null);
        plot.setOutlineVisible(false);
        plot.setLabelGenerator(null);
        plot.setShadowPaint(null);
        plot.setSectionOutlinesVisible(false);
        plot.setSeparatorsVisible(false);
        
        plot.setCenterTextColor(Color.decode("#667281"));
        plot.setCenterTextMode(CenterTextMode.FIXED);
        plot.setCenterTextFont(new Font("Arial", Font.PLAIN, 28));
        
        try
        {
            String  file    =   tempURLBase + "/" + fileName;
            
            ChartUtils.saveChartAsJPEG(new File(file), chart, width, height);
            
            return file;
        }
        catch (IOException ioe)
        {
            LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, ioe, "Exception occurred while creating Ring Chart.");
        }
        
        return null;
    }
    
    public static String getRingChart()
    {
        return new RingChart().addData("Completed", 20, GREEN).addData("Incomplete", 80, GREY).getChartImage();
    } 
    
    public static void main(String[] args)
    {
        new RingChart().addData("Completed", 20, GREEN).addData("Incomplete", 80, GREY).getChartImage();
    }
}
