<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
 
<oneit:dynIncluded>
<%
    boolean                 toRedirect  =   GenericObjDF.getOrCreateObject (request, "CultureCriteriaTemplate", CultureCriteriaTemplate.REFERENCE_CultureCriteriaTemplate);
    CultureCriteriaTemplate template    =   (CultureCriteriaTemplate) process.getAttribute("CultureCriteriaTemplate");
    String                  nextPage    =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(template != null && !toRedirect, "Invalid template in culture templates");
    
    SecUser                 secUser         =   SecUser.getTXUser(transaction);
    CompanyUser             companyUser     =   secUser.getExtension(CompanyUser.REFERENCE_CompanyUser);
    HiringTeam              hiringTeam      =   companyUser.getSelectedTeam();

    if(hiringTeam != template.getHiringTeam())
    {
        response.sendRedirect(WebUtils.getArticleByShortCut(transaction, WebUtils.ADMIN_HOME).getLink(request));
    }

    template.pipelineCultureCriteriaTemplate().toCultureCriterias().toCultureElement().toRatings().uniqueVals(); //preloading data
%>
    <script type="text/javascript">
        
        $(document).ready(function(){
            recalcFunction = setupRecalc ($("form#editCultureTemplate"), {'recalcOnError':true});
        });

    </script>
    
    <oneit:form name="editCultureTemplate" method="post"    enctype="multipart/form-data">
        
        <h1 class="page-title page-title-with-arrow edit-template">
            <oneit:button cssClass="arrow-btn-blue"  name="gotoPage" value=" " skin="link"
                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)         
                                                            .mapEntry("cancelProcess", true)
                                                            .toMap() %>">
                <img src="images/arrow-left-prev_blue.svg" />
            </oneit:button>
            View/Edit Culture Template
        </h1>
        <div class="form-group row box-border">
            <div class="col-md-1">
                <label><oneit:label GUIName="Title" /></label>
            </div>
            <div class="col-md-5">
                <oneit:ormInput obj="<%= template %>"    type="text" attributeName="TemplateName"    cssClass="form-control" />
            </div>
            <%
                if(template.getHiringTeam().showHasClientSupport())
                {
            %>
                    <div class="col-md-1">
                        <label><oneit:label GUIName="Client" /></label>
                    </div>
                    <div class="col-md-5 wider-select">
                        <tagfile:ormsingleasso_select obj="<%= template %>"  assocName="Client"  options="<%= Utils.getClientsByHiringTeam(transaction) %>"/>
                    </div>
            <%
                }
            %>
        </div>
        <div class="container-fluid">
            <div class="main-tab-template">
                <span class="job-details culture">Culture</span>
            </div>
            <div class="form-page-area nopadding"> 
                <div class="create-job"> 
                    <div class="form-page-section darkbg">
                        <div class="form-group">
                            <label><oneit:label GUIName="Organisation Culture Statement" /> <a href="#" title="Note description gose here." class="info-icon"><img src="images/info-icon.png" /></a></label>
                            <oneit:ormtextarea    obj="<%= template %>" attributeName="CultureStatement"  cssClass="form-control textarea-box"/>
                        </div>
                    </div>

                    <oneit:dynInclude   page="/extensions/adminportal/inc/culture_details.jsp"  CultureCriteriaTemplate="<%= template %>"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
                </div>
            </div>
        </div>
        <div class="text-center save-template">
            <oneit:button   value="Save Template"   name="save" cssClass="btn btn-primary top-margin-25 largeBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .toMap() %>" />
            <div class="save-template-text">Saving this template will not affect any previously created or filled jobs</div>
        </div>
    </oneit:form>
</oneit:dynIncluded>