import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { combineLatest } from 'rxjs/observable/combineLatest';
import { Subscription } from 'rxjs/Subscription';
import { AppService } from '../../app.service';
import { SEARCH, SERVICES } from '../../constants';
import { MessageTemplateModel } from '../../models/messageTemplate.model';
import { SorterModel } from '../../models/sorterModel';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';
import { AdminPortalLayoutService } from '../admin-portal/admin-portal-layout/admin-portal-layout.service';
import { BaseComponent } from '../base/base.component';

@Component({
    selector: 'app-list-message-template',
    templateUrl: './list-message-template.component.html'
})
export class ListMessageTemplateComponent extends BaseComponent implements OnInit {

    subscriptions: Array<Subscription> = [];
    myTemplates: Array<MessageTemplateModel> = [];
    sharedTemplates: Array<MessageTemplateModel> = [];
    sortOptions: Array<SorterModel>;
    showLoader = false;
    processing = false;

    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private searchService: SearchService,
        private appService: AppService,
        private adminPortalLayoutService: AdminPortalLayoutService
    ) {
        super(utilsService);
    }

    ngOnInit(): void {
        this.sortOptions = [
            new SorterModel('Alphabetical (A-Z)', true),
            new SorterModel('Alphabetical (Z-A)', false)
        ];
        this.showLoader = true;
        this.processing = true;

        this.startComponent();
        this.subscriptions.push(this.adminPortalLayoutService.userDataUpdated
            .subscribe(
                () => {
                    this.startComponent();
                }
            ));
    }

    startComponent(): void {

        if (!this.processing) {
            return;
        }

        this.processing = false;
        const sharedMsgParams = {
            OnlyGlobalTemplate: true
        };
        const myMsgParams = {
            OnlyGlobalTemplate: false
        };

        this.subscriptions.push(
            combineLatest(
                this.appService.getSearchListing(SERVICES.MESSAGE_TEMPLATES, 'All', myMsgParams, [], SEARCH.MESSAGE_TEMPLATE),
                this.appService.getSearchListing(SERVICES.MESSAGE_TEMPLATES, 'All', sharedMsgParams, [], SEARCH.MESSAGE_TEMPLATE)
            )
                .subscribe(
                    (response: [Array<MessageTemplateModel>, Array<MessageTemplateModel>]) => {
                        this.myTemplates = response[0].filter(message => message.HiringTeam ===
                            this.adminPortalLayoutService.getHiringTeamID().ObjectID);
                        this.sharedTemplates = response[1];
                        this.sortSpecificTemplate('myTemplates');
                        this.sortSpecificTemplate('sharedTemplates');
                        this.showLoader = false;
                    }
                )
        );
    }

    sortSpecificTemplate(arrayName: string): void {
        this[arrayName] = this.utilsService.sort(this[arrayName],
            ['TemplateName'], [this.sortOptions[0].ascending ? 1 : -1], false);
    }

    sortMessageTemplates($event): void {
        if (!$event.data[0]) {
            return;
        }
        const sort = $event.data[0];
        this.showLoader = true;
        this.myTemplates = this.utilsService.sort(this.myTemplates,
            ['TemplateName'], [sort.ascending ? 1 : -1], false);
        this.sharedTemplates = this.utilsService.sort(this.sharedTemplates,
            ['TemplateName'], [sort.ascending ? 1 : -1], false);
        this.showLoader = false;

    }

    onRowSelect(data: MessageTemplateModel): void {
        this.router.navigate(['/admin/edit-message-template', data.ObjectID]);
    }
}
