import { OnDestroy } from '@angular/core';
import { Subscription } from 'rxjs';
import { UtilsService } from '../../oneit/services/utils.service';

export class BaseComponent implements OnDestroy {

    isLoading = false;
    subscriptions: Array<Subscription> = [];
    hiringTeam: string;

    constructor(
        protected baseUtilsService: UtilsService
    ) {
    }

    ngOnDestroy(): void {
        this.baseUtilsService.unsubscribeSubscriptions(this.subscriptions);
    }

}
