package performa.orm;

import java.util.Set;
import oneit.objstore.BaseBusinessClass;
import oneit.objstore.cloning.BusinessCopyHelper;
import oneit.objstore.cloning.StandardAssocCopyingRule;
import oneit.security.SecUser;


public class MessageTemplate extends BaseMessageTemplate
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public MessageTemplate ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    public int getDelayInMin() 
    {
        return (getDelayHrs() * 60) + getDelayMin();
    }

    @Override
    public Integer getVariance() 
    {
        return super.getVariance() != null ? super.getVariance() : 0;
    }

    @Override
    public Integer getDelayHrs() 
    {
        return super.getDelayHrs() != null ? super.getDelayHrs() : 0;
    }

    @Override
    public Integer getDelayMin() 
    {
        return super.getDelayMin() != null ? super.getDelayMin(): 0;
    }
    
    private StandardAssocCopyingRule getCloneForCopy()
    {
        return new StandardAssocCopyingRule()
        {
            @Override
            protected Boolean shouldClone (BaseBusinessClass from,String assocName,BaseBusinessClass to)
            {
                if (to instanceof MessageTemplate)
                {
                    return Boolean.TRUE;
                }

                return null;
            }
        };
    }
    
    public MessageTemplate getClonedTemplate()
    {
        return (MessageTemplate) BusinessCopyHelper.copyRootBusinessObject (this, null, getCloneForCopy());
    }
}