
package performa.orm.types;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import oneit.appservices.dbenums.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class BO_IndustryPersistenceMgr extends AbstractEnumeratedBOPersistenceMgr
{
    private static final LoggingArea BO_IndustryPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "BO_Industry");

    // Private attributes corresponding to business object data
    private String dummyName;
    private String dummyValue;
    private String dummyDescription;
    private long dummySortOrder;
    private boolean dummyDisabled;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Name = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Value = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Description = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_SortOrder = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_Disabled = DefaultAttributeHelper.INSTANCE;
    



    public BO_IndustryPersistenceMgr ()
    {
        dummyName = (String)(HELPER_Name.initialise (dummyName));
        dummyValue = (String)(HELPER_Value.initialise (dummyValue));
        dummyDescription = (String)(HELPER_Description.initialise (dummyDescription));
        dummySortOrder = (long)(HELPER_SortOrder.initialise (dummySortOrder));
        dummyDisabled = (boolean)(HELPER_Disabled.initialise (dummyDisabled));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_industry.Object_id as id, {PREFIX}tl_industry.Object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_industry.Object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_industry.NAME, {PREFIX}tl_industry.VALUE, {PREFIX}tl_industry.DESCRIPTION, {PREFIX}tl_industry.SORT_ORDER, {PREFIX}tl_industry.DISABLED,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, BO_Industry.REFERENCE_BO_Industry);

                if (objectToReturn instanceof BO_Industry)
                {
                    LogMgr.log (BO_IndustryPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a BO_Industry");
                }
            }

            PersistentSet tl_industryPSet = allPSets.getPersistentSet(id, "tl_industry", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_industryPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_industryPSet.containsAttrib(BO_Industry.FIELD_Name)||
                    !tl_industryPSet.containsAttrib(BO_Industry.FIELD_Value)||
                    !tl_industryPSet.containsAttrib(BO_Industry.FIELD_Description)||
                    !tl_industryPSet.containsAttrib(BO_Industry.FIELD_SortOrder)||
                    !tl_industryPSet.containsAttrib(BO_Industry.FIELD_Disabled))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (BO_IndustryPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                BO_Industry result = new BO_Industry ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_industry " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_industry.Object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_industryPSet = allPSets.getPersistentSet(objectID, "tl_industry");
            

            
            if (tl_industryPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_industryPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_industry " +
                                                           "SET NAME = ?, VALUE = ?, DESCRIPTION = ?, SORT_ORDER = ?, DISABLED = ? , Object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_industry.Object_id = ? AND " + getConcurrencyCheck (sqlMgr, "Object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Name.getForSQL(dummyName, tl_industryPSet.getAttrib (BO_Industry.FIELD_Name))).listEntry (HELPER_Value.getForSQL(dummyValue, tl_industryPSet.getAttrib (BO_Industry.FIELD_Value))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_industryPSet.getAttrib (BO_Industry.FIELD_Description))).listEntry (HELPER_SortOrder.getForSQL(dummySortOrder, tl_industryPSet.getAttrib (BO_Industry.FIELD_SortOrder))).listEntry (HELPER_Disabled.getForSQL(dummyDisabled, tl_industryPSet.getAttrib (BO_Industry.FIELD_Disabled))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT Object_id, Object_LAST_UPDATED_DATE FROM {PREFIX}tl_industry WHERE Object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_industry", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (BO_IndustryPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_industry");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_industry for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (BO_IndustryPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_industryPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (BO_IndustryPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_industryPSet = allPSets.getPersistentSet(objectID, "tl_industry");
        

        LogMgr.log (BO_IndustryPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_industryPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_industryPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_industry " +
                                                       "WHERE tl_industry.Object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("Object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT Object_id FROM {PREFIX}tl_industry WHERE Object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_industry");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_industry for row:" + objectID;

                    LogMgr.log (BO_IndustryPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_industryPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryALL (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryALL");
    }
    public ResultSet executeSearchQueryBY_NAME (SQLManager sqlMgr, String name) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryBY_NAME");
    }
    public ResultSet executeSearchQueryBY_VALUE (SQLManager sqlMgr, String value) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryBY_VALUE");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, BO_Industry> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (BO_Industry.REFERENCE_BO_Industry.getObjectIDSpace (), r.getLong ("id"));
            BO_Industry resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, BO_Industry.REFERENCE_BO_Industry);

                if (cachedElement instanceof BO_Industry)
                {
                    LogMgr.log (BO_IndustryPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (BO_Industry)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a BO_Industry");
                }
            }
            else
            {
                PersistentSet tl_industryPSet = allPSets.getPersistentSet(objectID, "tl_industry", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new BO_Industry ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (BO_IndustryPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_industry " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (BO_Industry.SEARCH_ALL))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: 
                    filter = "object_id IS NOT NULL"
                           + "  ";
                    searchParams = new Object[] {  };
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_industry " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (BO_Industry.SEARCH_BY_NAME))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: 
                    filter = "NAME = ?"
                           + "  ";
                    searchParams = new Object[] { criteria.get ("name") };
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_industry " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        else if (searchType.equals (BO_Industry.SEARCH_BY_VALUE))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: 
                    filter = "VALUE = ?"
                           + "  ";
                    searchParams = new Object[] { criteria.get ("value") };
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_industry " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            
                BaseBusinessClass[] resultsArray = super.find(searchType, allPSets, criteria, context, sqlMgr);
                Vector              results = new Vector ();
                
                for (int x = 0 ; x < resultsArray.length ; ++x)
                {
                    if (resultsArray[x] instanceof BO_Industry)
                    {
                        results.add (resultsArray[x]);
                    }
                    else
                    {
                        // Ignore
                    }
                }
                
                resultsArray = new BaseBusinessClass[results.size ()];
                results.copyInto (resultsArray);

                return resultsArray;
            
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_industryPSet = allPSets.getPersistentSet(objectID, "tl_industry", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_industryPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_industryPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_industryPSet.setAttrib(BO_Industry.FIELD_Name, HELPER_Name.getFromRS(dummyName, r, "NAME"));
        tl_industryPSet.setAttrib(BO_Industry.FIELD_Value, HELPER_Value.getFromRS(dummyValue, r, "VALUE"));
        tl_industryPSet.setAttrib(BO_Industry.FIELD_Description, HELPER_Description.getFromRS(dummyDescription, r, "DESCRIPTION"));
        tl_industryPSet.setAttrib(BO_Industry.FIELD_SortOrder, HELPER_SortOrder.getFromRS(dummySortOrder, r, "SORT_ORDER"));
        tl_industryPSet.setAttrib(BO_Industry.FIELD_Disabled, HELPER_Disabled.getFromRS(dummyDisabled, r, "DISABLED"));
        
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_industryPSet = allPSets.getPersistentSet(objectID, "tl_industry");
        

        
        if (tl_industryPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_industryPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_industry " +
                                     "  (NAME, VALUE, DESCRIPTION, SORT_ORDER, DISABLED,   Object_id, Object_LAST_UPDATED_DATE, Object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?,    ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_Name.getForSQL(dummyName, tl_industryPSet.getAttrib (BO_Industry.FIELD_Name))).listEntry (HELPER_Value.getForSQL(dummyValue, tl_industryPSet.getAttrib (BO_Industry.FIELD_Value))).listEntry (HELPER_Description.getForSQL(dummyDescription, tl_industryPSet.getAttrib (BO_Industry.FIELD_Description))).listEntry (HELPER_SortOrder.getForSQL(dummySortOrder, tl_industryPSet.getAttrib (BO_Industry.FIELD_SortOrder))).listEntry (HELPER_Disabled.getForSQL(dummyDisabled, tl_industryPSet.getAttrib (BO_Industry.FIELD_Disabled)))  .listEntry (objectID.longID ()).toList().toArray());

            tl_industryPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
