<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.ASSESSMENT_CRITERIA);

    Debug.assertion(job != null, "Job is null in admin portal create job");

    CultureCriteriaTemplate[]   templates   =   job.getCultureTemplates();   
%>
    
    <script type="text/javascript">
        
        function enableElementRating(importanceRadio){
            
           var importanceGroup =   $(importanceRadio).closest('.rate-toggle');
                
            importanceGroup.find('li.active').removeClass("active" );
            importanceGroup.find("input[type='radio']:checked").closest('li').addClass("active" );

            var criteriaDiv   =   $(importanceRadio).closest('.criteria_section');

            if(importanceGroup.find("input[type='radio']:checked").val() !== 'NOT_APPLICABLE')
            {
                criteriaDiv.find(".element_rating_radio").removeProp("disabled");
            }
            else
            {
                criteriaDiv.find(".element_rating_radio").prop("disabled",true);
                criteriaDiv.find(".element_rating_radio").prop('checked', false);
            }
        }
        
        $(document).ready(function(){
            
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
            
            $(".importance_radio").change(function(){
                enableElementRating(this);
            });
            $(".importance_radio").each(function(){
                enableElementRating(this);
            });
            
            $("select[name$='CultureTemplate']").change(function(){
                $("button[name$='loadCultureFromTemplate']").click();
            });
                        
            var showError = true;
            addPostRecalcHandler (function ($fieldThatChanged) {
                if(showError) {
                    showError = false;
                    $('.errorField input, .errorField select, .errorField textarea, .errorField .assocObjDesc').eq(0).focus();
                }
                recalcFunction();
            });
        });
        
    </script>
    
    <oneit:form name="editJob" method="post" enctype="multipart/form-data">
    
        <div class="container-fluid">
                 
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <h1 class="page-title">Create a job</h1>
       
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="3"    data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <%
                job.setCompletedCulture(Boolean.TRUE);
            %>

            <oneit:button   value=" "   name="loadCultureFromTemplate"  cssClass="hide"
                            requestAttribs="<%= CollectionUtils.mapEntry ("Job", job)
                                                                .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                .toMap() %>" />
            <div class="form-page-area">
                <div class="create-job">
                    <div class="assessment-criteria">
                        <div class="form-group">
                            <label class="label-16 work-title">Culture</label>
                            <p>
                              Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit.
                            </p>      
                        </div>
                        <%
                            if(templates.length > 0)
                            {
                        %>
                                <div class="form-group row wider-select">
                                    <div class="col-md-12">
                                    <tagfile:ormsingleasso_select   obj="<%= job %>"    assocName="CultureTemplate" options="<%= templates %>"  
                                                                    blankValue="Optional: Select from previously defined Cultures"/>
                                    </div>
                                </div>              
                        <%
                            }
                        %>
                        <div class="form-group row">
                            <div class="col-md-4">
                                <label><oneit:ormlabel  obj="<%= job %>"    field="Country" /></label>
                                <oneit:ormEnum  obj="<%= job %>"    attributeName="Country" cssClass="form-control"/>
                            </div>
                            <div class="col-md-4">
                                <label><oneit:ormlabel  obj="<%= job %>"    field="State" /></label>
                                <oneit:ormEnum  obj="<%= job %>"    attributeName="State" cssClass="form-control"/>
                            </div>
                            <div class="col-md-4">
                                <label><oneit:ormlabel  obj="<%= job %>"    field="City" /></label>
                                <oneit:ormInput obj="<%= job %>"    type="text" attributeName="City"    cssClass="form-control" />      
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-md-4">
                            <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= job %>"  id="is-remote"    attributeName="Remote"  type="checkbox"/>
                                <oneit:recalcClass  htmlTag="span"  classScript="job.getRemote() != null && job.getRemote() ? 'checked': 'unchecked'"    job="<%= job %>">
                                    <label for="is-remote">
                                        <oneit:label GUIName="Remote?" />
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                        </div>
                        </div>
                        
                        
                        <div class="form-brack-line-sub"></div> 
                    <%
                        FormTag     jobForm     = FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder = jobForm.getFormBuilder();

                        job.pipelineJob().toCultureCriterias().toCultureElement().toRatings().uniqueVals(); //preloading data

                        for(CultureClass cultureClass : CultureClass.getCultureClassArray())
                        {
                    %>
                            <div class="form-group">
                                <div class="work-belonging">
                                    <oneit:toString value="<%= cultureClass %>" mode="EscapeHTML"/>
                                </div>
                            <%
                                for(CultureCriteria criteria : job.getCultureCriteriasForClass(cultureClass))
                                {
                                    String  optionKey   = WebUtils.getRadioSingleAssocKey(request, criteria, CultureCriteria.SINGLEREFERENCE_CultureElementRating);
                                    String  formValue   = formBuilder.fieldValue (optionKey, criteria.getCultureElementRating() == null ? "" : String.valueOf(criteria.getCultureElementRatingID()));
                            %>
                                    <div class="criteria_section culture-margin-bottom">
                                        <div class="work-radio-title">
                                            <oneit:toString value="<%= criteria.getCultureElement() %>" mode="EscapeHTML"/>
                                        </div>
                                        <div class="work-rating">
                                            <div class="rate-background">
                                                <span class="arrow-up-gray"></span>
                                                <span class="rate-label">
                                                    <oneit:ormlabel  obj="<%= criteria %>"   field="Importance" />
                                                </span>
                                                <span class="rate-toggle">
                                                    <ul class="nav nav-pills nav-justified">
                                                    <%
                                                        String  importanceKey   =   WebUtils.getInputKey(request, criteria, CultureCriteria.FIELD_Importance);
                                                        String  importanceValue =   formBuilder.fieldValue (importanceKey, criteria.getImportance() == null ? "" : criteria.getImportance().getName());

                                                        for(Importance importance : Importance.getImportanceArray())
                                                        {
                                                            boolean isSelected      =   CollectionUtils.equals(importanceValue, importance.getName());
                                                            String  importanceId    =   String.valueOf(criteria.getID().longID()) + "_importance_" + importance.getName();
                                                            String  selected        =   isSelected ? "checked" : "";
                                                            String  activeClass     =   isSelected ? "active" : "";
                                                    %>
                                                            <li class="<%= activeClass%>">
                                                                <a href="javascript:void(0)" class="importance">

                                                                    <input type="radio" name="<%= importanceKey %>" id="<%= importanceId %>"    class="importance_radio"    value="<%= importance.getName() %>" <%= selected %>/>
                                                                    <label for="<%= importanceId %>"><oneit:toString value="<%= importance.getCultureDescription() %>" mode="EscapeHTML" /></label>
                                                                </a>
                                                            </li>
                                                    <%
                                                        }
                                                    %>
                                                    </ul>
                                                </span>
                                            </div>
                                        </div>
                                    <%
                                        for (CultureElementRating rating : criteria.getCultureElement().getRatingsSet())
                                        {
                                            String  ratingId    = String.valueOf(rating.getID().longID());
                                            String  selectedStr = (CollectionUtils.equals(ratingId, formValue) ? "checked" : "");
                                    %>
                                            <div class="<%= "radio radio-primary workplace-radio " %>">
                                                <input type="radio" name="<%= optionKey %>" id="<%= ratingId %>"    class="element_rating_radio"    value="<%= ratingId %>" <%= selectedStr %> >
                                                <label for="<%= ratingId %>">
                                                    <oneit:toString value="<%= rating %>"   mode="EscapeHTML"/>
                                                </label>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                                    <div class="form-brack-line-sub"></div>
                            <%
                                }
                            %>
                            </div>
                    <%
                        }
                    %>
                        
                        <div class="form-group">
                            <div class="styled_checkboxes">
                                <div class="checkbox checkbox-primary">
                                    <oneit:ormInput obj="<%= job %>"  id="save-assess-check"  attributeName="SaveCultureTemplate"   type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="job.showSaveCultureTemplate() ? 'checked': 'unchecked'"    job="<%= job %>">
                                        <label for="save-assess-check">
                                            <oneit:ormlabel  obj="<%= job %>"    field="SaveCultureTemplate" />
                                        </label>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                        </div>
                        <oneit:recalcClass  htmlTag="div"   classScript="job.showSaveCultureTemplate() ? 'form-group template-save show': 'form-group template-save hide'"  job="<%= job %>">
                            <div class="input-group input-group-lg">
                                <div class="icon-addon addon-lg">
                                    <oneit:ormInput obj="<%= job %>"    type="text" attributeName="CultureTemplateName" cssClass="form-control" />
                                </div>
                                <span class="input-group-btn">
                                    <oneit:button   value="SAVE"    name="saveCultureTemplate"  cssClass="btn btn-primary"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("Job", job)
                                                                                        .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                                        .toMap() %>" />
                                </span>
                            </div>
                        </oneit:recalcClass>
                        <div class="text-center">
                            <oneit:button   value="Proceed to Requirements" name="gotoPage" cssClass="btn btn-primary top-margin-25 largeBtn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>" />
                        </div>
                    </div>
                </div>
            </div>                                    
        </div>
    </oneit:form>
</oneit:dynIncluded>