import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { PlaceholderOptionsEnum } from './models/placeholderOptions.enum';
import { TemplateTypeEnum } from './models/templateType.enum';
import { EnumService } from './oneit/services/enum.service';
import { SearchService } from './oneit/services/search.service';
import { UtilsService } from './oneit/services/utils.service';

@Injectable()

export class AppService {

    constructor(
        private enumService: EnumService,
        private searchService: SearchService,
        private utilsService: UtilsService
    ) {

    }

    getMessageTemplateTypeEnum(): Observable<Array<TemplateTypeEnum>> {
        return this.enumService.getEnums('TemplateTypes', true);
    }

    getPlaceholderOptionsEnum(): Observable<Array<PlaceholderOptionsEnum>> {
        return this.enumService.getEnumsWithNULLOptionLabel('PlaceholderOptions', 'Select variable');
    }

    getTypes(serviceName: string): Observable<Array<any>> {
        return this.enumService.getEnums(serviceName, true);
    }

    getSearchListing(serviceName: string, queryType: string, queryParams, assocs, searchName): Observable<Array<any>> {
        return this.searchService.searchAndSaveSearchRequest(serviceName, queryType,
            queryParams, assocs, null, null, null, null, searchName, false)
            .map(
                data =>
                    this.utilsService.convertResponseToObjects(data, assocs)
            );
    }
}
