package performa.utils;

import oneit.business.content.Article;
import oneit.business.content.jsp.ContentDF;
import oneit.servlets.jsp.BaseJSP;
import oneit.utils.CollectionUtils;
import javax.servlet.http.*;
import oneit.business.content.jsp.*;
import oneit.objstore.*;
import oneit.servlets.jsp.ORMSimpleAssocTag;
import oneit.servlets.orm.DataInputHandler;
import oneit.servlets.orm.DataMap;


public class WebUtils 
{
    public static final String ADMIN_PORTAL     = "AdminPortal";
    public static final String APPLICANT_PORTAL = "ApplicantPortal";
    public static final String ADMIN_HOME       = "AdminHome";
    public static final String APPLICANT_HOME   = "ApplicantHome";
    public static final String CREATE_JOB       = "CreateJob";
    public static final String ASSESSMENT_CRITERIA  = "AssessmentCriteria";
    public static final String WORKPLACE_CULTURE    = "WorkplaceCulture";
    public static final String JOB_MATCH        = "JobMatchAssessment";
    public static final String JOB_REVIEW       = "JobReview";
    public static final String APPLY_JOB        = "ApplyJob";
    public static final String JOB_APPLICATION  = "JobApplication";
    public static final String CREATED_JOB      = "CreatedJob";
    public static final String EDIT_JOB         = "EditJob";
    public static final String JOBS             = "Jobs";
    public static final String CANDIDATES       = "Candidates";
    public static final String CLIENTS          = "Clients";
    public static final String EDIT_CLIENT          = "EditClient";
    public static final String MANAGE_USERS     = "ManageUsers";
    public static final String MY_COMPANY       = "MyCompany";
    public static final String BILLING          = "Billing";
    public static final String VIEW_APPLICANTS  = "ViewApplicants";
    public static final String APPLICANTS_SHORTLIST  = "ApplicantsShortlist";
    public static final String APPLICANTS_GRID  = "ApplicantsGrid";
    public static final String VIEW_APPLICATION = "ViewApplication";
    public static final String UNSUITABLE_APPS  = "UnsuitableApps";
    public static final String VIEW_APPLICANTS_GRID  = "ViewApplicantsGrid";
    public static final String APPLICANT_ACCOUNT_VERIFICATION   = "ApplicantAccountVerification";
    public static final String RESET_PASSWORD_ARTICLE           = "ResetPasswordEmail";
    public static final String COMPANY_ACCOUNT_VERIFICATION     = "CompanyAccountVerification";
    public static final String MY_DETAILS           = "MyDetails";
    public static final String RESET_PASSWORD       = "ResetPassword";
    
    
    public static String getArticleLink(HttpServletRequest request, ObjectTransaction objTran, String articleShortcut, String renderMode)
    {
        return getArticleLink(request, getArticleByShortCut(objTran, articleShortcut), "Page");
    }
    
    
    public static String getArticleLink(HttpServletRequest request, Article article, String renderMode)
    {
        return article.getLink(request, CollectionUtils.mapEntry("cms.rm", renderMode).toMap());
    }
    
    
    public static String getSamePageInRenderMode (HttpServletRequest request, String renderMode)
    {
        BaseJSP theJSP  = (BaseJSP) request.getAttribute(BaseJSP.JSP_SERVLET);
        Article article = (Article)theJSP.getData(request, ContentDF.ARTICLE);
        
        return getArticleLink(request, article, renderMode);
    }
    
    
    public static String getRadioSingleAssocKey(HttpServletRequest request, BaseBusinessClass bbc, String singleAssocName)
    {
        DataMap             dataMap = DataMap.getDataMap (request, true);
        ORMSimpleAssocTag.SimpleAssocHandler  dih     = new ORMSimpleAssocTag.SimpleAssocHandler (bbc, singleAssocName);
        return dataMap.storeORMHandler (dih, bbc, singleAssocName);
    }
    
    
    public static String getInputKey(HttpServletRequest request, BaseBusinessClass bbc, String attributeName)
    {
        DataMap             dataMap     = DataMap.getDataMap (request, true);
        DataInputHandler    dih         = new DataInputHandler.SimpleAttributeHandler (bbc, attributeName, null);
        return dataMap.storeORMHandler (dih, bbc, attributeName);
    }
    
    
    public static boolean descendsFrom (Article article, String parentArticleIdFilter)
    {
        if (article.getIdentifier ().equals (parentArticleIdFilter))
        {
            return true;
        }
        else if (article.getCategory () != null && article.getCategory () != article)
        {
            return descendsFrom(article.getCategory (), parentArticleIdFilter);
        }
        else
        {
            return false;
        }
    }
    
    
    public static String getPortalName(ObjectTransaction objTran, Article article)
    {   
        Article applicantArticle    =   getArticleByShortCut(objTran, APPLICANT_PORTAL);
        Article adminArticle        =   getArticleByShortCut(objTran, ADMIN_PORTAL);
    
        if(applicantArticle != null)
        {
            if(descendsFrom(article, applicantArticle.getIdentifier()))
            {
                return APPLICANT_PORTAL;
            }
        }
        
        if(adminArticle != null)
        {
            if(descendsFrom(article, adminArticle.getIdentifier()))
            {
                return ADMIN_PORTAL;
            }
        }
        
        return "";
    }
    
    
    public static Article getArticleByShortCut(ObjectTransaction objTran, String shortCut)
    {
        return ShortcutFilter.doShortcutSearch(objTran, shortCut);
    }
    
    
    public static Boolean isCreateJob(String renderMode)
    {
        return renderMode.equals(CREATE_JOB) || 
                renderMode.equals(ASSESSMENT_CRITERIA) || 
                renderMode.equals(WORKPLACE_CULTURE) || 
                renderMode.equals(JOB_MATCH) || 
                renderMode.equals(JOB_REVIEW) || 
                renderMode.equals(CREATED_JOB);
    }
}