import { UserModel } from './user.model';
import { CLASSES } from '../config/constants';
import { BaseModel } from './base.model';
import { CandidateTemplateModel } from './candidate-template.model';

export class CandidateModel extends BaseModel {
    ObjectClass = CLASSES.CANDIDATE;
    Phone: string;
    ForgotPasswordMailSendDate: string;
    ForgotPasswordKey: string;
    VerificationMailSendDate: string;
    VerificationKey: string;
    IsAccountVerified: boolean;
    IsPasswordChanged: boolean;
    GoogleAddressText: string;
    OccupationPreference: any;
    EmploymentStatus: string;
    EmploymentPreference: Array<any>;
    InterestedInOpportunities: string;
    IsEmailIngest: boolean;
    IsMaskedEmail: boolean;
    KnownAsAlias: string;
    PrivacyPolicyAgreed: boolean;
    ConditionsAgreed: boolean;
    HasValidAddress: boolean;
    IsFirstTime: boolean;
    User = new UserModel();
    TestInput: string;
    TestAnalysises: Array<string>;
    JobApplications: Array<string>;
    CultureCriteriaAnswers: Array<string>;
    ProfileAssessmentAnswers: Array<string>;
    DiversityAnswers: Array<string>;
    CandidateTemplates: Array<CandidateTemplateModel>;
    AllTempletes: Array<{
        Availability: string;
        Description: string;
        Disabled: boolean;
        FullImageURI: string;
        ThumbnailImageURI: string;
        Name: string;
        SortOrder: number;
        Value: string;
        ImgPath: string;
        CanUse: boolean;
    }>
}
