import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { MessageEngineApplicantViewService } from './message-engine-applicant-view.service';

import { EngineApplicantView } from './message-engine-applicant-view.model';

@Component({
    selector: 'app-message-engine',
    templateUrl: './message-engine.component.html'
})
export class MessageEngineApplicantViewComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    engineApplicantView = new EngineApplicantView();
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private messageEngineApplicantViewService: MessageEngineApplicantViewService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getEngineApplicantViewByID(params.id);
                    } else {
                        this.utilsService.createObject(this.engineApplicantView, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
    }
    

    getEngineApplicantViewByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.messageEngineApplicantViewService.getEngineApplicantViewByID(id, assocs)
            .subscribe(
                data => {
                    this.engineApplicantView = data;
                    this.updatedObjs[this.engineApplicantView.ObjectID] = this.engineApplicantView;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveEngineApplicantView(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.engineApplicantView.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/message-engine", idToNavigate]);
                                return;
                            }
                            this.getEngineApplicantViewByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}
